% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{FindBridgeIntegrationAnchors}
\alias{FindBridgeIntegrationAnchors}
\title{Find integration bridge anchors between query and extended bridge-reference}
\usage{
FindBridgeIntegrationAnchors(
  extended.reference,
  query,
  query.assay = NULL,
  dims = 1:30,
  scale = FALSE,
  reduction = c("lsiproject", "pcaproject"),
  integration.reduction = c("direct", "cca"),
  verbose = TRUE
)
}
\arguments{
\item{extended.reference}{BridgeReferenceSet object generated from
\code{\link{PrepareBridgeReference}}}

\item{query}{A query Seurat object}

\item{query.assay}{Assay name for query-bridge integration}

\item{dims}{Number of dimensions for query-bridge integration}

\item{scale}{Determine if scale the query data for projection}

\item{reduction}{Dimensional reduction to perform when finding anchors.
Options are:
\itemize{
   \item{pcaproject: Project the PCA from the bridge onto the query. We
   recommend using PCA when bridge and query datasets are from scRNA-seq}
   \item{lsiproject: Project the LSI from the bridge onto the query. We
   recommend using LSI when bridge and query datasets are from scATAC-seq or scCUT&TAG data.
   This requires that LSI or supervised LSI has been computed for the bridge dataset, and the
   same features (eg, peaks or genome bins) are present in both the bridge
   and query.
}
}}

\item{integration.reduction}{Dimensional reduction to perform when finding anchors
between query and reference.
Options are:
\itemize{
   \item{direct: find anchors directly on the bridge representation space}
   \item{cca: perform cca on the on the bridge representation space and then find anchors
}
}}

\item{verbose}{Print messages and progress}
}
\value{
Returns an \code{AnchorSet} object that can be used as input to
\code{\link{IntegrateEmbeddings}}.
}
\description{
Find a set of anchors between unimodal query and the other unimodal reference
using a pre-computed \code{\link{BridgeReferenceSet}}.
These integration anchors can later be used to integrate query and reference
using the \code{\link{IntegrateEmbeddings}} object.
}
