% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/preprocessing.R,
%   R/preprocessing5.R
\name{LogNormalize}
\alias{LogNormalize}
\alias{LogNormalize.data.frame}
\alias{LogNormalize.V3Matrix}
\alias{LogNormalize.default}
\title{Normalize Raw Data}
\usage{
LogNormalize(data, scale.factor = 10000, margin = 2L, verbose = TRUE, ...)

\method{LogNormalize}{data.frame}(data, scale.factor = 10000, margin = 2L, verbose = TRUE, ...)

\method{LogNormalize}{V3Matrix}(data, scale.factor = 10000, margin = 2L, verbose = TRUE, ...)

\method{LogNormalize}{default}(data, scale.factor = 10000, margin = 2L, verbose = TRUE, ...)
}
\arguments{
\item{data}{Matrix with the raw count data}

\item{scale.factor}{Scale the data; default is \code{1e4}}

\item{margin}{Margin to normalize over}

\item{verbose}{Print progress}

\item{...}{Arguments passed to other methods}
}
\value{
A matrix with the normalized and log-transformed data
}
\description{
Normalize Raw Data
}
\examples{
mat <- matrix(data = rbinom(n = 25, size = 5, prob = 0.2), nrow = 5)
mat
mat_norm <- LogNormalize(data = mat)
mat_norm

}
\concept{preprocessing}
