% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{new_shapley}
\alias{new_shapley}
\title{Class constructor for class \code{shapley}.}
\usage{
new_shapley(phi = numeric(), mu_tilde = NULL, non_centrality = NULL)
}
\arguments{
\item{phi}{A \eqn{p}-dimensional vector (or a \eqn{n \times p} matrix) containing the
Shapley values (outlyingness-scores) of a \eqn{p}-dimensional data vector (or a \eqn{n \times p} data matrix).}

\item{mu_tilde}{Optional. A \eqn{p}-dimensional vector (or a \eqn{n \times p} matrix) containing the
alternative reference points based on the regular cells of the original observations.}

\item{non_centrality}{Optional. The non-centrality parameters for the Chi-Squared distribution,
which are given by \code{mahlanobis(mu_tilde, mu, Sigma)}.}
}
\value{
Named list of class \code{shapley}, containing the input parameters.
}
\description{
This function creates an object of class \code{shapley} that is returned by the \code{\link{shapley}} function.
}
