% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sr.r
\name{summary.sr}
\alias{summary.sr}
\alias{summary.sropt}
\title{Summarize a Sharpe, or (delta) optimal Sharpe object.}
\usage{
\method{summary}{sr}(object, ...)

\method{summary}{sropt}(object, ...)
}
\arguments{
\item{object}{an object of class \code{sr}, \code{sropt} or \code{del_sropt}.}

\item{...}{additional arguments affecting the summary produced, though
ignored here.}
}
\value{
When an \code{sr} object is input, the object cast to class \code{summary.sr} with some
additional fields:
\describe{
\item{tval}{the equivalent t-statistic.}
\item{pval}{the p-value under the null.}
\item{serr}{the standard error of the Sharpe ratio.}
}
When an \code{sropt} object is input, the object cast to class \code{summary.sropt} with some
additional fields:
\describe{
\item{pval}{the p-value under the null.}
\item{SRIC}{the SRIC value, see \code{\link{sric}}.}
}
}
\description{
Computes a \sQuote{summary} of an object, adding in some statistics.
}
\details{
Enhances an object of class \code{sr}, \code{sropt} or \code{del_sropt} to also 
include t- or T-statistics, p-values, and so on.
}
\examples{
# Sharpe's 'model': just given a bunch of returns.
set.seed(1234)
asr <- as.sr(rnorm(253*3),ope=253)
summary(asr)
}
\references{
Sharpe, William F. "Mutual fund performance." Journal of business (1966): 119-138.
\url{http://ideas.repec.org/a/ucp/jnlbus/v39y1965p119.html}
}
\seealso{
\code{\link{print.sr}}.

Other sr: \code{\link{as.sr}}, \code{\link{confint.sr}},
  \code{\link{dsr}}, \code{\link{is.sr}},
  \code{\link{plambdap}}, \code{\link{power.sr_test}},
  \code{\link{predint}}, \code{\link{print.sr}},
  \code{\link{reannualize}}, \code{\link{se}},
  \code{\link{sr_equality_test}}, \code{\link{sr_test}},
  \code{\link{sr_unpaired_test}}, \code{\link{sr_vcov}},
  \code{\link{sr}}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
