% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistractorAnalysis.R
\name{DistractorAnalysis}
\alias{DistractorAnalysis}
\title{Function for item distractor analysis}
\usage{
DistractorAnalysis(data, key, p.table = FALSE, num.groups = 3)
}
\arguments{
\item{data}{character: data matrix or data frame. See \strong{Details}.}

\item{key}{character: answer key for the items.}

\item{p.table}{logical: should the function return the proportions. If \code{FALSE} (default)
the counts are returned.}

\item{num.groups}{numeric: number of groups to that should be respondents splitted.}
}
\description{
Performs distractor analysis for each item and optional number of groups.
}
\details{
This function is adapted version of \code{distractor.analysis} function from \code{CTT} package.
The scores are calculatede using the item data and key. The respondents are then splitted into
the \code{num.groups}-quantiles and the number (or proportion) of respondents in each quantile is
reported with respect to their answers.

The \code{data} is a matrix or data frame whose rows represents unscored item response from a
multiple-choice test and columns correspond to the items.

The \code{key} must be a vector of the same length as \code{ncol(data)}.
}
\examples{
\dontrun{
# loading difMedicaltest data set
data(difMedicaltest, package = "difNLR")
data  <- difMedicaltest[, colnames(difMedicaltest) != "gender"]
# loading difMedicalkey
data(difMedicalkey, package = "difNLR")
key  <- difMedicalkey

# distractor analysis for difMedicaltest data set
DistractorAnalysis(data, key)

# distractor analysis for difMedicaltest data set with proportions
DistractorAnalysis(data, key, p.table = T)

# distractor analysis for difMedicaltest data set for 6 groups
DistractorAnalysis(data, key, num.group = 6)

}


}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
adela.drabinova@gmail.com \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr
}

