% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DDplot.R
\name{DDplot}
\alias{DDplot}
\title{Graphical representation of difficulty and discrimination in item analysis}
\usage{
DDplot(data, item.names)
}
\arguments{
\item{data}{numeric: binary data matrix or data frame. See \strong{Details}.}

\item{item.names}{character: the names of items.}
}
\description{
Plots difficulty and discrimination for items ordered by difficulty.
}
\details{
The \code{data} is a matrix or data frame whose rows represents examinee answers
("1" correct, "0" incorrect) and columns correspond to the items. The \code{item.names}
argument stands for names of items. If not specified, the names of dataset columns are used.
}
\examples{
\dontrun{
# loading 100-item medical admission test data set
data(dataMedical)

# Difficulty/Discrimination plot of dataMedical data set
DDplot(dataMedical)
}
}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
adela.drabinova@gmail.com \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr
}
