% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa_parallel.R
\name{plot.sia_parallel}
\alias{plot.sia_parallel}
\title{Plot Method for Parallel Analysis Output}
\usage{
\method{plot}{sia_parallel}(x, y, ...)
}
\arguments{
\item{x}{object of class \code{sia_parallel} to plot.}

\item{y}{\emph{ignored}}

\item{...}{additional argument:
\describe{\item{\code{show_kaiser}}{\emph{logical}, whether to show
horizonal lines denoting Kaiser boundaries (eigenvalue 0 and/or 1 for FA
and/or PCA, respectively). Defaults to \code{TRUE}.}}}
}
\description{
You can call this method to plot an existing object resulting from
\code{fa_paralell()} function, which behaves as a standard \code{data.frame},
but can be automatically recognized and processed with a dedicated plot
method. Also, you can \emph{post-hoc} disable the Kaiser boundaries shown by
default.
}
\examples{
\dontrun{
fa_parallel_result <- BFI2[, 1:60] \%>\% fa_parallel(plot = FALSE) # without plot
fa_parallel_result \%>\% plot() # generate plot from "fitted" object
fa_parallel_result \%>\% plot(show_kaiser = FALSE) # hide Kaiser boundaries
}

}
