% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ItemAnalysis.R
\name{ItemAnalysis}
\alias{ItemAnalysis}
\title{Compute traditional item analysis indices}
\usage{
ItemAnalysis(
  Data,
  minscore = NULL,
  maxscore = NULL,
  cutscore = NULL,
  criterion = NULL,
  k = NULL,
  l = NULL,
  u = NULL,
  bin = "deprecated"
)
}
\arguments{
\item{Data}{\emph{matrix} or \emph{data.frame} of items to be examined. Rows represent
respondents, columns represent items.}

\item{minscore, maxscore}{\emph{integer}, theoretical minimal/maximal score. If not
provided, these are computed on observed data. Automatically recycled to
the number of columns of the data.}

\item{cutscore}{\emph{integer} If provided, the input data are binarized
accordingly. Automatically recycled to the number of columns of the data.}

\item{criterion}{vector of criterion values.}

\item{k, l, u}{Arguments passed on to \code{\link[=gDiscrim]{gDiscrim()}}. Provide these if you want to
compute generalized upper-lower index along with a standard ULI (using \code{k}
= 3, \code{l} = 1, \code{u} = 3), which is provided by default.}

\item{bin}{\emph{deprecated}, use \code{cutscore} instead. See the \strong{Details}.}
}
\value{
A \code{data.frame} with following columns:
\item{\code{Difficulty}}{average score of the item divided by its range.}
\item{\code{Mean}}{average item score.}
\item{\code{SD}}{standard deviation of the item score.}
\item{\code{Cut.score}}{cut-score specified in \code{cutscore}.}
\item{\code{obs.min}}{observed minimal score.}
\item{\code{Min.score}}{minimal score specified in \code{minscore}; if not provided,
observed minimal score.}
\item{\code{obs.max}}{observed maximal score.}
\item{\code{Max.score}}{maximal score specified in \code{maxscore}; if not provided,
observed maximal score.}
\item{\code{Prop.max.score}}{proportion of maximal scores.}
\item{\code{RIT}}{item-total correlation (correlation between item score and
overall test score).}
\item{\code{RIR}}{item-rest correlation (correlation between item score and
overall test score without the given item).}
\item{\code{ULI}}{upper-lower index using the standard parameters (3 groups,
comparing 1st and 3rd).}
\item{\code{Corr.criterion}}{correlation between item score and criterion
\code{criterion}.}
\item{\code{gULI}}{generalized ULI. \code{NA} when the arguments \code{k}, \code{l}, and \code{u}
were not provided.}
\item{\code{Alpha.drop}}{Cronbach's alpha without given item.}
\item{\code{Index.rel}}{Gulliksen's (1950) item reliability index.}
\item{\code{Index.val}}{Gulliksen's (1950) item validity index.}
\item{\code{Perc.miss}}{Percentage of missed responses on the particular item.}
\item{\code{Perc.nr}}{Percentage of respondents that did not reached the item
nor the subsequent ones, see \code{\link[=recode_nr]{recode_nr()}} for further details.}
}
\description{
Computes various traditional item analysis indices including difficulty,
discrimination and item validity. For ordinal items, the function returns
scaled values for some of the indices. See the details below.
}
\details{
For calculation of generalized ULI index, it is possible to specify a custom
number of groups \code{k}, and which two groups \code{l} and \code{u} are to be compared.

In ordinal items, difficulty is calculated as difference of average score
divided by range (maximal possible score \code{maxscore} minus minimal possible
score \code{minscore}).

If \code{cutscore} is provided, item analysis is conducted on binarized data;
values greater or equal to cut-score are set to \code{1}, other values are set to
\code{0}. Both the \code{minscore} and \code{maxscore} arguments are then ingored and set to
0 and 1, respectively.
}
\examples{
\dontrun{
# binary dataset
dataBin <- dataMedical[, 1:100]
# ordinal dataset
dataOrd <- dataMedicalgraded[, 1:100]
# study success is the same for both data sets
StudySuccess <- dataMedical[, 102]

# item analysis for binary data
head(ItemAnalysis(dataBin))
# item analysis for binary data using also study success
head(ItemAnalysis(dataBin, criterion = StudySuccess))

# item analysis for binary data
head(ItemAnalysis(dataOrd))
# item analysis for binary data using also study success
head(ItemAnalysis(dataOrd, criterion = StudySuccess))
# including also item analysis for binarized data
head(ItemAnalysis(dataOrd,
  criterion = StudySuccess, k = 5, l = 4, u = 5,
  maxscore = 4, minscore = 0, cutscore = 4
))
}

}
\references{
Martinkova, P., Stepanek, L., Drabinova, A., Houdek, J.,
Vejrazka, M., & Stuka, C. (2017). Semi-real-time analyses of item
characteristics for medical school admission tests. In: Proceedings of the
2017 Federated Conference on Computer Science and Information Systems.
https://doi.org/10.15439/2017F380

Gulliksen, H. (1950). \emph{Theory of mental tests.} John Wiley & Sons Inc.
https://doi.org/10.1037/13240-000
}
\seealso{
\code{\link[=DDplot]{DDplot()}}, \code{\link[=gDiscrim]{gDiscrim()}}, \code{\link[=recode_nr]{recode_nr()}}
}
\author{
Patricia Martinkova \cr Institute of Computer Science of the Czech
Academy of Sciences \cr \email{martinkova@cs.cas.cz}

Jan Netik \cr Institute of Computer Science of the Czech Academy of
Sciences \cr \email{netik@cs.cas.cz}

Jana Vorlickova \cr Institute of Computer Science of the Czech Academy of
Sciences

Adela Hladka \cr Institute of Computer Science of the Czech Academy of
Sciences \cr \email{hladka@cs.cas.cz}
}
