% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkSim.R
\name{ltt.network}
\alias{ltt.network}
\title{Lineages thru time on a network}
\usage{
ltt.network(phy, node_times = NULL)
}
\arguments{
\item{phy}{An object of class 'evonet.'}

\item{node_times}{A numeric vector specifying times of each node. If left NULL then the function will use the output from node.depth.edgelength(phy)}
}
\value{
A dataframe that consists of intervals. The first column denotes the start time of the interval while the second column denotes the end time. The third column depicts the number of lineages present in that interval.
NOTE: due to computational precision, two nodes that appear to occur on the same time (as in the case of lineage neutral and generative hybridization) may be part of different intervals in the output data frame.
}
\description{
This function Computes the number of lineages thru time on a network
}
\examples{
set.seed(17) ##smallest Quartan prime as seed
##Generate a tree with extinct leaves
net<-sim.bdh.age(1,1,5,2,1,c(1/3,1/3,1/3),hyb.inher.fxn = make.uniform.draw(),complete=TRUE)[[1]]
ltt.network(net)
}
