% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkSim.R
\name{reconstructedNetwork}
\alias{reconstructedNetwork}
\title{Remove Extinct Lineages from a Phylogenetic Network}
\usage{
reconstructedNetwork(net)
}
\arguments{
\item{net}{An object of class 'evonet.'}
}
\value{
net The reconstructed network with all extinct tips removed.
}
\description{
This function removes all extinct tips from a phylogenetic network, returning the reconstructed network.
}
\examples{
set.seed(17) ##smallest Quartan prime as seed
##Generate a tree with extinct leaves
net<-sim.bdh.age(1,1,5,2,1,c(1/3,1/3,1/3),hyb.inher.fxn = make.uniform.draw(),complete=TRUE)[[1]]
recon_net<-reconstructedNetwork(net)
plot(net)
plot(recon_net)
}
