% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS.est.Ratio.R
\name{SS.est.Ratio}
\alias{SS.est.Ratio}
\title{Sightability estimate or ratio with variance components estimator from
Steinhorst and Samuel (1989) and Samuel et al. (1992).  This is merely a
stub and has not been implemented.}
\usage{
SS.est.Ratio(
  numerator,
  denominator,
  srates,
  nh,
  Nh,
  stratum,
  subunit,
  covars,
  beta,
  varbeta,
  smat = NULL
)
}
\arguments{
\item{numerator, denominator}{Number of animals for the numerator and
denominator of the ratio in each independently sighted group}

\item{srates}{Plot-level sampling probability}

\item{nh}{Number of sample plots in each stratum}

\item{Nh}{Number of population plots in each stratum}

\item{stratum}{Stratum identifiers (associated with the independently
observed animal groups)}

\item{subunit}{Plot ID (associated with the independently observed animal
groups)}

\item{covars}{Matrix of sightability covariates (associated with the
independently observed animal groups)}

\item{beta}{Logistic regression parameter estimates (from fitted
sightability model)}

\item{varbeta}{Estimated variance-covariance matrix for the logistic
regression parameter estimates (from fitted sightability model)}

\item{smat}{Estimated variance-covariance matrix for the inflation factors
(1/probability of detection).  This is an n.animal x n.animal matrix, and is
usually calculated within the SS.est.Ratio function.  Non-null values can be
passed to the function (e.g., if a bootstrap is used to estimate uncertainty
due to the estimated detection parameters).}
}
\value{
\item{ratio.hat}{Sightability estimate of ratio, ratio^}
\item{VarRatio}{Estimated variance of ratio^} \item{VarSamp, VarSight,
VarMod}{Estimated variance component due to sampling, sightability and model
set to NA}
}
\description{
Estimates ratio, with variance estimated using Steinhorst and Samuel (1989)
and Samuel et al.'s (1992) estimator.  Usually, this function will be
called by Sight.Est.Ratio()
}
\references{
Steinhorst, R. K., and M.D. Samuel. 1989.  Sightability adjustment methods
for aerial surveys of wildlife populations.  Biometrics 45:415-425.

Wong, C. 1996.  Population size estimation using the modified
Horvitz-Thompson estimator with estimated sighting probabilities.
Dissertation, Colorado State University, Fort Collins, USA.
}
\seealso{
\code{\link{Sight.Est}}, \code{\link{Wong.est}}
}
\author{
Carl James Schwarz, cschwarz.stat.sfu.ca@gmail.com
}
\keyword{methods}
