% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/preprocessing.R
\name{RegionStats}
\alias{RegionStats}
\alias{RegionStats.default}
\alias{RegionStats.ChromatinAssay}
\alias{RegionStats.Seurat}
\title{Compute base composition information for genomic ranges}
\usage{
RegionStats(object, ...)

\method{RegionStats}{default}(object, genome, verbose = TRUE, ...)

\method{RegionStats}{ChromatinAssay}(object, genome, verbose = TRUE, ...)

\method{RegionStats}{Seurat}(object, genome, assay = NULL, verbose = TRUE, ...)
}
\arguments{
\item{object}{A Seurat object, Assay object, or set of genomic ranges}

\item{...}{Arguments passed to other methods}

\item{genome}{A BSgenome object}

\item{verbose}{Display messages}

\item{assay}{Name of assay to use}
}
\value{
Returns a dataframe
}
\description{
Compute the GC content, region lengths, and dinucleotide base frequencies
for regions in the assay and add to the feature metadata.
}
\examples{
\dontrun{
library(BSgenome.Hsapiens.UCSC.hg19)
RegionStats(
  object = rownames(atac_small),
  genome = BSgenome.Hsapiens.UCSC.hg19
)
}
\dontrun{
library(BSgenome.Hsapiens.UCSC.hg19)
RegionStats(
  object = atac_small[['peaks']],
  genome = BSgenome.Hsapiens.UCSC.hg19
)
}
\dontrun{
library(BSgenome.Hsapiens.UCSC.hg19)
RegionStats(
  object = atac_small,
  assay = 'bins',
  genome = BSgenome.Hsapiens.UCSC.hg19
)
}
}
\concept{motifs}
