% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{subset.Fragment}
\alias{subset.Fragment}
\title{Subset a Fragment object}
\usage{
\method{subset}{Fragment}(x, cells = NULL, ...)
}
\arguments{
\item{x}{A Fragment object}

\item{cells}{Vector of cells to retain}

\item{...}{Arguments passed to other methods}
}
\value{
Returns a subsetted \code{\link{Fragment}} object
}
\description{
Returns a subset of a \code{\link{Fragment-class}} object.
}
\examples{
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
cells <- colnames(x = atac_small)
names(x = cells) <- paste0("test_", cells)
frags <- CreateFragmentObject(path = fpath, cells = cells, verbose = FALSE, tolerance = 0.5)
subset(frags, head(names(cells)))
}
\seealso{
\code{\link[base]{subset}}
}
\concept{fragments}
