\name{TEX.sde}
\alias{TEX.sde}
\alias{TEX.sde.default}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Converting Sim.DiffProc Objects to LaTeX
}
\description{
These methods produces the related LaTeX table and mathematic expression for Sim.DiffProc environment.
}
\usage{
TEX.sde(object, \dots)

\method{TEX.sde}{default}(object, \dots)	
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{
an objects from class \code{\link{MCM.sde}} and \code{\link{MEM.sde}}. Or an R vector of \code{\link[base]{expression}} of SDEs, i.e., drift and diffusion coefficients.
}
  \item{\dots}{
arguments to be passed to \code{\link[knitr]{kable}} function if \code{object} from class \code{\link{MCM.sde}}.
}
}
\details{
New tools for constructing tables and  mathematical expressions with \code{Sim.DiffProc} package.

An overview of this package, see \code{\link[utils]{browseVignettes}('Sim.DiffProc')} for more informations.
}

\references{
  Xie Y (2015). 
  Dynamic Documents with R and knitr. 
  2nd edition. Chapman and Hall/CRC, Boca Raton, Florida. 
  ISBN 978-1498716963, URL \url{https://yihui.org/knitr/}.

  Wickham H (2015). 
  Advanced R. 
  Chapman & Hall/CRC The R Series. CRC Press. ISBN 9781498759809.
}
\author{
A.C. Guidoum
}

\seealso{
\code{\link[knitr]{kable}} create tables in LaTeX, HTML, Markdown and reStructuredText. 

\code{\link[utils]{toLatex}} converting R Objects to BibTeX or LaTeX.
}
\examples{

## LaTeX mathematic for an R expression of SDEs
## Copy and paste the following output in your LaTeX file

# Example 1

f <- expression(-mu1 * x) 
g <- expression(mu2 * sqrt(x)) 
TEX.sde(object = c(drift = f, diffusion = g))

# Example 2

f <- expression(mu1*cos(mu2+z),mu1*sin(mu2+z),0) 
g <- expression(sigma,sigma,alpha) 
TEX.sde(object = c(drift = f, diffusion = g))

## LaTeX mathematic for object of class 'MEM.sde'
## Copy and paste the following output in your LaTeX file

# Example 3

mem.mod3d <- MEM.sde(drift = f, diffusion = g)
TEX.sde(object = mem.mod3d)

## LaTeX table for object of class 'MCM.sde'
## Copy and paste the following output in your LaTeX file

# Example 4

\dontrun{
mu1=0.25; mu2=3; sigma=0.05; alpha=0.03
mod3d <- snssde3d(drift=f,diffusion=g,x0=c(x=0,y=0,z=0),M=100,T=10)

stat.fun3d <- function(data, i){
   d <- data[i,]
   return(c(mean(d$x),mean(d$y),mean(d$z), 
            var(d$x),var(d$y),var(d$z)))
			}
mcm.mod3d = MCM.sde(mod3d,statistic=stat.fun3d,R=10,parallel="snow",ncpus=parallel::detectCores(),
                    names=c("m1","m2","m3","S1","S2","S3"))
					
TEX.sde(object = mcm.mod3d, booktabs = TRUE, align = "r", caption ="\\LaTeX~ 
         table for Monte Carlo results generated by \\code{TEX.sde()} method.")
}		 

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{LaTeX}
