% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.beta.from.B.R
\name{compute.beta.from.B}
\alias{compute.beta.from.B}
\title{Co-regulation coefficient computation}
\usage{
compute.beta.from.B(B_fun)
}
\arguments{
\item{B_fun}{Numeric vector of global co-regulation coefficients}
}
\value{
Numeric matrix \code{n*n} of the co-regulation coefficients, where \code{n} is the length of \code{B_fun}.

If \code{beta_fun} is \code{NULL}, \code{compute.beta.from.B} returns \code{NULL}.
}
\description{
Computes the matrix of co-regulation coefficients \eqn{M_\beta} from a vector of global co-regulation coefficients \code{B}
}
\details{
Enzymes are supposed to be all co-regulated, i.e. no \eqn{\beta} value is null.
}
\examples{
B <- 1/c(0.5,0.2,0.3)
correl <- "RegPos"

is.B.accurate(B,3,correl)

beta <- compute.beta.from.B(B)


}
\seealso{
Use function \code{\link{is.B.accurate}} to verify \code{B_fun} conformity.
}
