% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SIR.R, R/SISe.R, R/SISe3.R,
%   R/SISe3_sp.R, R/SISe_sp.R
\docType{methods}
\name{prevalence}
\alias{prevalence}
\alias{prevalence,SIR-method}
\alias{prevalence,SISe-method}
\alias{prevalence,SISe3-method}
\alias{prevalence,SISe3_sp-method}
\alias{prevalence,SISe_sp-method}
\title{Prevalence}
\usage{
prevalence(model, type = c("pop", "bnp", "wnp"), i = NULL, ...)

\S4method{prevalence}{SIR}(model, type = c("pop", "bnp", "wnp"), i = NULL,
  ...)

\S4method{prevalence}{SISe}(model, type = c("pop", "bnp", "wnp"), i = NULL,
  ...)

\S4method{prevalence}{SISe3}(model, type, i, age = 1:3, ...)

\S4method{prevalence}{SISe3_sp}(model, type, i, age = 1:3, ...)

\S4method{prevalence}{SISe_sp}(model, type = c("pop", "bnp", "wnp"),
  i = NULL, ...)
}
\arguments{
\item{model}{The \code{model} to calculated the prevalence from.}

\item{type}{The type of prevalence measure to calculate:
\code{'pop'} (default) calcalates the proportion of the
individuals in the population that have disease (model
specific) at each time point in \code{tspan}, \code{'bnp'}
calculates the between-node prevalence, and \code{'wnp'}
calculates the within-node prevalence.}

\item{i}{Indices specifying the nodes to include in the
calculation of the prevalence. Default is \code{NULL}, which
includes all nodes.}

\item{...}{Additional arguments affecting the measure}

\item{age}{For models with age categories, the age category to
include in the calculation. Default is that all age categories
are included.}
}
\value{
Vector when type equals \code{'pop'} or \code{'bnp'} but
    matrix when type equals \code{'wnp'}.
}
\description{
Calculate the proportion of individuals with disease, or the
proportion of nodes with individuals with disease, or the
proportion of individuals with disease in each node.
}
\keyword{methods}
