% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_gameteFunctions.R
\name{sim_gameteFormation}
\alias{sim_gameteFormation}
\title{Simulate formation of gametes.}
\usage{
sim_gameteFormation(chrom_map, allele_IDs, burn_in = 1000,
  gamma_params = c(2.63, 2.63/0.5))
}
\arguments{
\item{chrom_map}{Data.frame.  A data.frame consisting of three columns: column 1 contains the chromosome numbers, column 2 start postion of chromosome (in cM), column 3 end position of chromosome (in cM).}

\item{allele_IDs}{List of length 2. The identification numbers for the respective paternal and maternal alleles of the individual for whom we wish to simulate recombination. (Can accomodate numeric or string entries)}

\item{burn_in}{Numeric. The "burn-in" distance in centiMorgan, as defined by Voorrips and Maliepaard (2012), which is required before simulating the location of the first chiasmata with interference. By default, \code{burn_in = 1000}.
The burn in distance in cM. By default, \code{burn_in = 1000}.}

\item{gamma_params}{Numeric list of length 2. The respective shape and rate parameters of the gamma distribution used to simulate distance between chiasmata.  By default, \code{gamma} \code{_params} \code{= c(2.63, 2*2.63)}, as discussed in Voorrips and Maliepaard (2012).}
}
\value{
A list containing the following:

\code{chrom_haps} A list of dataframes, each dataframe is a set of four recombined haplotypes for a single chromosome (in the order specified in \code{chrom_map}), each with a gamete group identifier column.

\code{gamete_group} A list of lists, each list contains the crossover positions for a single chromosome (in the order specified in \code{chrom_map}).
}
\description{
Simulate formation of gametes. \strong{This function will likely become an internal function}.
}
\keyword{internal}
