% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plots.R
\name{hpo.plot.marginal.freqs}
\alias{hpo.plot.marginal.freqs}
\title{Plot marginal frequency of terms}
\usage{
hpo.plot.marginal.freqs(hpo.terms, term.descendancy.matrix, phi.trace,
  max.terms = 20, colour.gradient = TRUE, size.gradient = TRUE,
  custom.labels = c(), show.proportion = TRUE, colours = NULL, ...)
}
\arguments{
\item{hpo.terms}{R-Object representation of HPO}

\item{term.descendancy.matrix}{Logical term descendancy matrix, dimensions symmetrically labelled by terms, and where by a cell value of TRUE indicates that the row is the ancestor of the column term (in the sense of the DAG structure of the HPO}

\item{phi.trace}{Delta trace output from \code{\link{sim.reg}} function, where the rows are the values of phi at each iteration}

\item{max.terms}{Specify the maximum number of terms to appear in the plot}

\item{colour.gradient}{Logical indicating whether to colour terms in the plot according to their marginal frequencies (blue being the least frequent, yellow the most)}

\item{size.gradient}{Logical indicating whether to colour terms in the plot according to their marginal frequencies}

\item{custom.labels}{Character vector of custom labels for terms (named by corresponding term IDs)}

\item{show.proportion}{Logical indicating whether to append the `inclusion in phi' rate to the labels in the terms}

\item{colours}{Vector of colours (named by HPO term IDs) for corresponding terms in plot}

\item{...}{Additional parameters to be passed to \code{hpo.plot}}
}
\value{
Plots graph
}
\description{
Plot graphic depicting marginal frequency of individual HPO terms in context of related terms in the ontology
}

