% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{log_odds_trace}
\alias{log_odds_trace}
\title{Get trace of log odds of observing the rare genotype (y = 1) for individual cases from the output of \code{\link{sim_reg}}}
\usage{
log_odds_trace(term_sim_mat, term_descendancy_matrix, term_sets, samples,
  g = rep(FALSE, length(term_sets)), as_probs = FALSE)
}
\arguments{
\item{term_sim_mat}{Numeric matrix with rows and columns corresponding to (and named by) term IDs, and cells containing the similarity between the row and column term}

\item{term_descendancy_matrix}{Logical term descendancy matrix, dimensions symmetrically labelled by terms, and where by a cell value of TRUE indicates that the row is the ancestor of the column term (in the sense of the DAG structure of the HPO.}

\item{term_sets}{List of character vectors of ontological term IDs.}

\item{samples}{Object of class \code{sim_reg_samples}, i.e. the output of the \code{\link{sim_reg}} function.}

\item{g}{Genotype log odds offsets per individual.}

\item{as_probs}{Boolean value indicating whether to convert the log odds to probabilities.}
}
\value{
Numeric matrix of log odds trace per individual.
}
\description{
Get trace of log odds of observing the rare genotype (y = 1) for individual cases from the output of \code{\link{sim_reg}}
}

