% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{draw_U}
\alias{draw_U}
\title{Samples from a Multivariate Normal Distribution}
\usage{
draw_U(Psi_chol, n_y)
}
\arguments{
\item{Psi_chol}{Cholesky decomposition of the covariance matrix.}

\item{n_y}{number of markers.}
}
\description{
Simulates from a multivariate normal distribution and returns a
matrix with appropriate dimensions.
}
\examples{
library(SimSurvNMarker)
set.seed(1)
n_y <- 2L
K <- 3L * n_y
Psi <- drop(rWishart(1, K, diag(K)))
Psi_chol <- chol(Psi)

# example
dim(draw_U(Psi_chol, n_y))
samples <- replicate(100, draw_U(Psi_chol, n_y))
samples <- t(apply(samples, 3, c))

colMeans(samples) # ~ zeroes
cov(samples) # ~ Psi

}
