% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.hoops.R
\name{plot.hoops}
\alias{plot.hoops}
\title{Plots the trajectory with sites of interest and other hoops}
\usage{
\method{plot}{hoops}(x, y, Name, R, first = 'n', colours = c('orange','darkgreen','red'), 
lwds = c(2,2,2), number_sites=-1, ...)
}
\arguments{
\item{x}{array of the x-coordinates describing the trajectory}

\item{y}{array of the y-coordinates describing the trajectory}

\item{Name}{name of the data, which is used for any saved files and plot titles}

\item{R}{radius value to use}

\item{first}{if \code{'y'}, the algorithm will look for the second greatest maximum percent drop if the first results in the first circle being the only non-identified site}

\item{colours}{list of the hoops' colours}

\item{lwds}{list of hoop widths}

\item{number_sites}{number of sites to manually show the results for}

\item{...}{additional arguments to \link[graphics]{plot}}
}
\value{
Plot of the identified sites' positions
}
\description{
Plots the trajectory of the animal with the different hoops (sites of interest, removed circles and other circles) overlaid.
}
\details{
This function plots the trajectory of the animal with the identified sites of interest, removed circles and other circles plotted on top. The colours of the three types of the circles and their widths can also be defined. This can be used to see visually where the sites are along the trajectory.
}
\examples{
\donttest{##Find the current working directory
wd = getwd()
##Set the working directory as the temporary one
setwd(tempdir())
##Load the data
data(OU_14)
t=unlist(OU_14["t"])
X=unlist(OU_14["X"])
Y=unlist(OU_14["Y"])

class(X) = "hoops"
class(Y) = "hoops"

##Calculate the residence time with a radius of 0.3 and not including the first circle
Alt_Alg("OU_14",t,X,Y,0.3,first='y',save='y')

##Plot the positions of the identified sites as well as the non-overlapping circles
plot(X,Y,"OU_14",0.3)

##The colours for the hoops can be changed
plot(X,Y,"OU_14",0.3,first='y',colours=c('tan','chocolate','maroon'))

##The thickness of hoops can also be changed
plot(X,Y,"OU_14",0.3,first='y',lwds=c(0.5,2,3.5))

##It is also possible to manually choose the number of sites
plot(X,Y,"OU_14",0.3,first='y',number_sites=4)

##Reset the original working directory
setwd(wd)}
}
\references{
Munden, R., Borger , L., Wilson, R.P., Redcliffe, J., Loison, A., Garel, M. and Potts, J.P. in review. Making sense of ultra-high-resolution movement data: an algorithm for inferring sites of interest.
}
\seealso{
See also \code{\link{Alt_Alg}} to find the residence times. \code{\link{Sites}} can be used to find the coordinates of the centres of the sites and non-overlapping circles from the csv files produced by \code{\link{Alt_Alg}}.
}
\author{
Rhys Munden <rdmunden1@sheffield.ac.uk>
}
\keyword{Plots}
