% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotslapmeg.R
\name{plotslapmeg}
\alias{plotslapmeg}
\title{Plot the estimated random effects from SLaPMEG seperated for the study groups}
\usage{
plotslapmeg(obj, ...)
}
\arguments{
\item{obj}{An slapmeg object which is the output from \code{\link{slapmeg}} or
\code{\link{pairslapmeg}}. Note that the \code{fullreturn=TRUE}) must have been used.}

\item{\dots}{optional graphical parameters can be added with an \code{+} based on \code{\link{ggplot2}}
structure.}
}
\value{
returns NULL
}
\description{
This plot can provide a graphical insight into the source of effect (i.e. diffrential expression)
in relevent pathway.
}
\examples{
# simulate data with 8 omics
testdata<-simslapmeg(nY=8, ntime=5, nsubj = 30)
head(testdata)

#fit slapmeg to test for the differential expression of a pathway of size 5
fit<- slapmeg(Y1+Y2+Y6+Y7+Y8~time, ~1, grouping="group", subject="ID", data=testdata)

#Density plots for the estimated random effects
plotslapmeg(fit)

}
\references{
paper title goes here
}
\seealso{
\code{\link{slapmeg}}, \code{\link{multslapmeg}}, \code{\link{pairslapmeg}}
}
\author{
Mitra Ebrahimpoor

\email{m.ebrahimpoor@lumc.nl}
}
