% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_seurat_markers.R
\name{read_seurat_markers}
\alias{read_seurat_markers}
\title{Create "Marker_list" from Seurat object}
\usage{
read_seurat_markers(df, sort_by = "avg_log2FC", gene_filter = 20)
}
\arguments{
\item{df}{Dataframe generated by "FindAllMarkers" function, recommend
to use parameter "group.by = "Cell_type"" and "only.pos = TRUE".}

\item{sort_by}{Marker sorting parameter, select "avg_log2FC" or "p_val_adj".
Default parameters use "sort_by = "avg_log2FC"".}

\item{gene_filter}{The number of markers left for each cell type based
on the "sort_by" parameter's level of difference. Default parameters use
"gene_fliter = 20"}
}
\value{
The standardized "Marker_list" in the SlimR package.
}
\description{
Create "Marker_list" from Seurat object
}
\examples{
library(Seurat)
          data("pbmc_small")
          sce <- pbmc_small
          seurat_markers <- FindAllMarkers(sce,
                                           group.by = "RNA_snn_res.1",
                                           only.pos = TRUE)
          Markers_list_Seurat <- read_seurat_markers(seurat_markers,
          sort_by = "avg_log2FC",
          gene_filter = 10
          )

}
