% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stripPath.R
\name{stripPath}
\alias{stripPath}
\title{Remove the path from a vector of filenames}
\usage{
stripPath(vec)
}
\arguments{
\item{vec}{Character vector (usually containing filenames)}
}
\value{
Character vector with leading path removed from the filenames
}
\description{
Remove the path from a vector of filenames
}
\details{
Assumes paths are delineated using forward slashes.  If an \code{NA} is
supplied, then an \code{NA} is returned.  If the desired string doesn't
exist (see examples below), a \code{""} is returned.
}
\examples{
stripPath(c(a = "this.good.path/filename.R", b = "nopath.R", c = "/", d = NA,
            e = "only.paths.1/only.paths.2/", ""))

# An example with 'real' files
files <- dir(file.path(path.package(package = "Smisc"), "data"), full.names = TRUE)
print(files)
stripPath(files)
stripPath(stripExtension(files))
}
\author{
Landon Sego
}
\seealso{
Additional functions for filename manipulations:  \code{\link{stripExtension}}, \code{\link{getExtension}},
\code{\link{getPath}}, \code{\link{grabLast}}, \code{\link{basename}}, \code{\link{dirname}}
}
\keyword{misc}

