% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openDevice.R
\name{openDevice}
\alias{openDevice}
\title{Opens a graphics device based on the filename extension}
\usage{
openDevice(fileName, ...)
}
\arguments{
\item{fileName}{Character string giving the filename for the graphics
output. The following are acceptable filename extensions:
\code{ps}, \code{pdf}, \code{jpg}, \code{jpeg}, \code{tif}, \code{png}, or
\code{bmp}.}

\item{\dots}{Named arguments to the device functions listed above.  Arguments
that do not match are silently ignored.}
}
\value{
The graphics device is opened and the filename is invisibly
returned.
}
\description{
Based on the filename extension, will open plotting device  using one of the
following graphics functions:
\code{\link{postscript}}, \code{\link{pdf}}, \code{\link{jpeg}},
\code{\link{tiff}}, \code{\link{png}}, or \code{\link{bmp}}.
}
\examples{
# Open 3 example devices
openDevice("ex1.pdf", height=6, width=12)
plot(1:10, 1:10)

openDevice("ex1.jpg")
plot(1:10, 1:10)

openDevice("ex1.png")
plot(1:10, 1:10)

# List the devices and their filenames
dev.list()
dir(pattern = "ex1")

# Turn each of the 3 devices off
for (i in 1:3) {
  dev.off(dev.list()[length(dev.list())])
}

# Delete the created files
unlink(c("ex1.pdf","ex1.png","ex1.jpg"))

# List the current devices
dev.list()

}
\author{
Landon Sego
}
\keyword{misc}
