% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SWC.R
\name{SWC}
\alias{SWC}
\title{Soil water content}
\usage{
SWC(
  suc,
  par.shp = c(ths = 0.9, thr = 0, alfa = 0.02, n = 2),
  FUN.shp = "vg",
  modality = "uni",
  suc.negativ = TRUE
)
}
\arguments{
\item{suc}{Suction/pressure heads. Negative if suc.negativ = TRUE}

\item{par.shp}{named parameter in list or vector}

\item{FUN.shp}{Funktion for soil hydraulic properties (vG, PDI or bc) (see details)}

\item{modality}{pore size distribution ('uni' or 'bi')}

\item{suc.negativ}{set TRUE if suction/pressure heads are negative and FALSE if positive}
}
\value{
volumetric water content theta (th) [L³/L³]
}
\description{
Calculates the volumetric soil water content for a corresponding suction/pressure head (th(suc)) for unimodal or bimodal van Genuchten (vG), Peters-Durner-Iden (PDI) and Brooks and Corey (bc) (only unimodal) parameterisation.
}
\details{
\describe{\item{FUN.shp:}{
vG: van Genuchten (uni or bimodal) (vGM is working aswell) \cr
PDI: Peters-Durner-Iden with saturation function of van Genuchten (uni or bimodal) \cr
bc: Brooks and Corey (unimodal)}}
\describe{\item{par.shp (vG and PDI):}{
ths [-]: saturated water content \cr
thr [-]: residual water content\cr
alfa [1/L]: van Genuchten shape parameter \cr
n [-]: van Genuchten shape parameter \cr
m [-]: shape parameter (m = 1-(1/n) if missing)}
\item{par.shp (additional for 'PDI'):}{
h0 [L]: suction at water content of 0 (i.e. oven dryness) (h0 = 10^6.8 if missing, corresponding to oven dryness at 105°C (Schneider and Goss, 2012))}
\item{par.shp (additional for bimodal (modality = 'bi')):}{
w2 [-]: weigthing between pore space distributions \cr
alfa2 [1/L]: van Genuchten parameter alfa for second pore space distribution \cr
n2 [-]: van Genuchten parameter n for second pore space distribution \cr
m2 [-]: shape parameter (m2 = 1-(1/n2) if missing)}}
\describe{\item{par.shp (BC):}{
ths [-]: saturated water content \cr
thr [-]: residual water content\cr
alfa [1/L]: inverse of the air-entry value or bubbling pressure \cr
lambda [-]: pore size distribution index }}

PDI:\cr
theta(h) = (ths - thr) * Scap(h) + thr * Sad(h) \cr
\code{\link{Scap}: Rescaled capillary saturation function } \cr
\code{\link{Sad}: Relative saturation function for adsorbed water}

input for FUN.shp and modality works for upper- and lowercase letters \cr
}
\examples{
# --------------------------------------------
#  Unimodal van Genuchten
# --------------------------------------------
SWC(suc = seq(1, 1000, by = 1), par.shp = c(ths = 0.4, thr = 0, alfa = 0.02, n = 1.5),
FUN.shp = c('vG'), modality = 'uni', suc.negativ = FALSE)
# --------------------------------------------
#  Bimodal van Genuchten
# --------------------------------------------
SWC(suc = seq(1, 1000, by = 1),
par.shp = c(ths = 0.4, thr = 0, alfa = 0.02, n = 2, w2 = 0.2, alfa2 = 1, n2 = 10),
FUN.shp  = c('vG'), modality = c('bi'), suc.negativ = FALSE)
# --------------------------------------------
#  Unimodal PDI
# --------------------------------------------
SWC(suc = seq(1, 1000, by = 1), par.shp = list(ths = 0.4, thr = 0, n = 1.6, alfa = 0.02),
FUN.shp = c('pdi'), modality = c('uni'), suc.negativ = FALSE)
# --------------------------------------------
#  Brooks and Corey (BC) (only unimodal)
SWC(suc = seq(1, 1000, by = 1), par.shp = list(ths = 0.4, thr = 0, lambda =  0.211, alfa = 0.1),
FUN.shp = c('bc'), modality = c('uni'), suc.negativ = FALSE)
# --------------------------------------------
}
\references{
Van Genuchten, M. T. (1980). A closed-form equation for predicting the hydraulic conductivity of unsaturated soils. Soil science society of America journal, 44(5), 892-898.

Durner, W. (1994). Hydraulic conductivity estimation for soils with heterogeneous pore structure. Water Resources Research, 30(2), 211-223.

Peters, A. (2013). Simple consistent models for water retention and hydraulic conductivity in the complete moisture range. Water Resour. Res. 49, 6765–6780. physics-a review. Vadose Zone J. http://dx.doi.org/10.2136/vzj2012.0163.

Iden, S., Durner, W. (2014). Comment to Simple consistent models for water retention and hydraulic conductivity in the complete moisture range by A. Peters. Water Resour. Res. 50, 7530–7534.

Peters, A. (2014). Reply to comment by S. Iden and W. Durner on Simple consistent models for water retention and hydraulic conductivity in the complete moisture range. Water Resour. Res. 50, 7535–7539.

Schneider, M., & Goss, K. U. (2012). Prediction of the water sorption isotherm in air dry soils. Geoderma, 170, 64-69.

Brooks, R.H., and A.T. Corey (1964): Hydraulic properties of porous media. Hydrol. Paper 3. Colorado State Univ., Fort Collins, CO, USA.
}
\seealso{
\code{\link{Ku}} \code{\link{Sat}}
}
\author{
Ullrich Dettmann
}
