% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/management_df.R
\name{management_df}
\alias{management_df}
\title{Constructor for management_df}
\usage{
management_df(
  crop = NA,
  year = NA,
  date = NA,
  category = NA,
  operation = NA,
  device = NA,
  value = NA,
  unit = NA,
  machine = NA,
  product = NA,
  combination = NA,
  comments = NA,
  DMC = NA,
  C_content = NA,
  N_content = NA,
  crop_product = NA,
  crop_residue = NA,
  Cc_product = NA,
  Cc_residue = NA
)
}
\arguments{
\item{crop}{Name of the main crop. Must match a pre-existing list}

\item{year}{Year of the management operation ("YYYY")}

\item{date}{Date of the management operation ("YYYY-MM-DD")}

\item{category}{Categorization of the managment operation (1 level). Must match a pre-existing list.}

\item{operation}{Categorization of the managment operation (2 level). Must match a pre-existing list.}

\item{device}{Categorization of the managment operation (3 level). Must match a pre-existing list.}

\item{value}{Numerical value linked to managment operation (e.g., depth of tillage operation, mass of organic amendment)}

\item{unit}{Unit of the numerical value (e.g. cm, t/ha)}

\item{machine}{Further information on the machine used (e.g., type, manufacturer, tool)}

\item{product}{Further information on the applied product (e.g., name, manufacturer). Must match pre-existing list for organic amendments.}

\item{combination}{Indicate if a operation was done in combination with others. Use consequtive integer numbers if combinded operations occur. Leave empty if not combined.}

\item{comments}{Comments related to the management operation}

\item{DMC}{Dry matter content of organic amendments (gDM/kgFM)}

\item{C_content}{Carbon content of the amendments, relative to its dry matter (gC/kgDM)}

\item{N_content}{Nitrogen content of organic amendments, relative to its dry matter (gN/kgDM)}

\item{crop_product}{Crop product yield (tDM/ha)}

\item{crop_residue}{Crop residue mass (tDM/ha)}

\item{Cc_product}{Carbon content of the crop product (gC/kgDM)}

\item{Cc_residue}{Carbon content of the crop residue (gC/kgDM)}
}
\value{
a \code{\link[=management_df]{management_df()}}
}
\description{
This function is a constructor for empty objects of the \code{\link[=management_df]{management_df()}} class,
the core of the SoilManageR package.
}
\examples{
#creation of an empty management_df
management_df()
}
\seealso{
\itemize{
\item \code{\link[=management_df_from_excel]{management_df_from_excel()}} for importing a \code{management_df} from an excel template
\item \code{\link[=check_management_df]{check_management_df()}} to check the integrity of a \code{management_df}
\item \code{\link[=EXAMPLE_data]{EXAMPLE_data()}} for an example of a \code{management_df}
}
}
