% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linearScalarModel.R
\name{linearScalarModel}
\alias{linearScalarModel}
\title{Implementation of a general model for linear non-autonomous systems with scalar modifiers}
\usage{
linearScalarModel(
  t,
  A,
  C0,
  u,
  gamma,
  xi,
  xi_lag = 0,
  solver = deSolve.lsoda.wrapper
)
}
\arguments{
\item{t}{A vector containing the points in time where the solution is
sought.}

\item{A}{A square (n x n) matrix with compartmental structure}

\item{C0}{A vector of length n containing the initial amount of carbon for
the n pools.}

\item{u}{A vector of length n with constant mass inputs for the n pools.}

\item{gamma}{A scalar or data.frame object specifying the modifier for the
mass inputs.}

\item{xi}{A scalar, data.frame, function or anything that can be 
converted to a scalar function of time \code{\linkS4class{ScalarTimeMap}} 
object  specifying the external  (environmental and/or edaphic) effects on
decomposition rates.}

\item{xi_lag}{A time shift/delay  for the automatically 
created time dependent function xi(t)}

\item{solver}{A function that solves the system of ODEs. This can be
\code{\link{euler}} or \code{\link{deSolve.lsoda.wrapper}} or any other user
provided function with the same interface.}
}
\value{
A Model Object that can be further queried
}
\description{
This function implements a linear model with scalar modifier for inputs
and compartmental matrix.
}
\examples{
t=seq(0,52*200,1) # Fix me! Add an example.  
}
\references{
C.A., M. Mueller, S.E. Trumbore. 2012. Models of soil organic
matter decomposition: the SoilR package version 1.0. Geoscientific Model
Development 5, 1045-1060.
}
\seealso{
\code{\link{RothCModel}}. There are other
\code{\link{predefinedModels}} and also more general functions like
\code{\link{Model}}.
}
