% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setProperties.R
\name{setDR}
\alias{setDR}
\title{Manually set dimension reduction for a channel}
\usage{
setDR(sc, DR, reductName = NULL)
}
\arguments{
\item{sc}{A SoupChannel object.}

\item{DR}{The dimension reduction coordinates (e.g., tSNE).  This must be a data.frame, with two columns giving the two dimension reduction coordinates.  The data.frame must either have row names matching the row names of sc$metaData, or be ordered in the same order as sc$metaData.}

\item{reductName}{What to name the reduction (defaults to column names provided).}
}
\value{
A modified SoupChannel object for which the dimension reduction has been set.
}
\description{
Manually specify the dimension reduction
}
\examples{
sc = load10X(system.file('extdata','toyData',package='SoupX'))
mDat = read.table(system.file('extdata','toyData','metaData.tsv',package='SoupX'),sep='\t')
sc = setDR(sc,mDat[,c('tSNE_1','tSNE_2')])
}
