% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{ripAllRootsClique}
\alias{ripAllRootsClique}
\title{All possible RIP orderings}
\usage{
ripAllRootsClique(graph)
}
\arguments{
\item{graph}{a graph represented as a \code{graphNEL} object. If the input graph is not decomposable, the function will internally moralize and triangulate it.}
}
\value{
Given a graph, the function returns:
\itemize{
 \item{\code{elements}:  a list composed of four other lists:
  \itemize{
    \item{\code{cliques}: (a list of character vectors) variables contained in each maximal clique of the moralized and triangulated input graph}
    \item{\code{separators}: (a list of character vectors) unique separators, i.e., common variables among cliques}
    \item{\code{components}: (a dataframe) unique “clique | separator” elements defined on the basis of all rip orderings. Each element represents a conditional distribution (see Djordjilovic and Chiogna)}
    \item{\code{variables}: (a character vector) nodes of the graph }
  }
 }
 \item{\code{indices}: a list composed of two other lists:
   \itemize{
    \item{ \code{all}: (a list of character vectors) \code{cliques} and \code{separators} lists of variables}
    \item{ \code{ordering}: one dataframe for each identified ordering. Each data frame is a subset of size k (i.e., number of maximal cliques), of the \code{components} elements. The name of each list corresponds to the used root clique.}
   }
 }
 \item{\code{graph}: decomposable graph used in the identification of rip orderings. It may differ from the input graph. In fact, if the input graph is not decomposable, the function will internally moralize and triangulate it.}
}
}
\description{
The function identifies all possible clique orderings leading to distinct factorizations of the associated joint distribution.
}
\details{
For each root clique, the function uses \code{\link[gRbase]{rip}} function to identify a sequence of the set of cliques that satisfies the running intersection property by first ordering variables by the maximum cardinality search algortithm. The \code{root} argument is used to check which clique will be the first to enter in the rip ordering.
}
\examples{
if(require(gRbase)){

  ## decomposable graph
  ug.graph<-ug(~1:2:3+3:4+4:5:6:7)
  ug.rip.all<-ripAllRootsClique(ug.graph)
  # 7 variables
  length(ug.rip.all$elements$variables)
  # 3 max.cliques
  length(ug.rip.all$elements$cliques)
  # 7 unique components
  nrow(ug.rip.all$elements$components)
  # all rip orderings:
  ug.rip.all$indices$ordering

  ## directed graph
  dag.graph<-dag(~3:1+3:2+4:3)
  dag.rip.all<-ripAllRootsClique(dag.graph)
  # triangulated and morliazed graph
  dag.rip.all$graph
  # all rip orderings
  dag.rip.all$indices$ordering
}
}
\seealso{
\code{\link[gRbase]{rip}}
}
