% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{migrationflows_tbl_df}
\alias{migrationflows_tbl_df}
\title{Annual Origin–Destination Migration Flows Between Korean Regions}
\format{
A tibble with 2,601 observations and 20 variables:
\describe{
  \item{orig}{Origin region name (character)}
  \item{dest}{Destination region name (character)}
  \item{year}{Year of migration flow (integer)}
  \item{flow}{Number of migrants moving from origin to destination (integer)}
  \item{dist_cent}{Distance between region centroids (numeric)}
  \item{dist_min}{Minimum distance between regions (numeric)}
  \item{dist_pw}{Pairwise distance measure (numeric)}
  \item{contig}{Contiguity indicator: TRUE if regions share a border, FALSE otherwise (logical)}
  \item{orig_pop}{Population of the origin region (numeric)}
  \item{dest_pop}{Population of the destination region (numeric)}
  \item{orig_area}{Area of the origin region in square meters (numeric)}
  \item{dest_area}{Area of the destination region in square meters (numeric)}
  \item{orig_gdp_pc}{GDP per capita in the origin region (numeric)}
  \item{orig_ginc_pc}{Gross income per capita in the origin region (numeric)}
  \item{orig_iinc_pc}{Individual income per capita in the origin region (numeric)}
  \item{orig_pconsum_pc}{Private consumption per capita in the origin region (numeric)}
  \item{dest_gdp_pc}{GDP per capita in the destination region (numeric)}
  \item{dest_ginc_pc}{Gross income per capita in the destination region (numeric)}
  \item{dest_iinc_pc}{Individual income per capita in the destination region (numeric)}
  \item{dest_pconsum_pc}{Private consumption per capita in the destination region (numeric)}
}
}
\source{
Data taken from the \pkg{migest} package version 2.0.5
}
\usage{
data(migrationflows_tbl_df)
}
\description{
This dataset, migrationflows_tbl_df, is a tibble containing annual migration flows between
South Korea's first-level administrative regions from 2012 to 2020. It includes geographic,
economic, and demographic indicators for both origin and destination regions.
}
\details{
The dataset name has been kept as 'migrationflows_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
SouthKoreAPIs package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not been modified
in any way.
}
