% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\docType{methods}
\name{mutate}
\alias{mutate}
\alias{transform}
\alias{mutate}
\alias{mutate,SparkDataFrame-method}
\alias{transform}
\alias{transform,SparkDataFrame-method}
\title{Mutate}
\usage{
mutate(.data, ...)

transform(`_data`, ...)

\S4method{mutate}{SparkDataFrame}(.data, ...)

\S4method{transform}{SparkDataFrame}(`_data`, ...)
}
\arguments{
\item{.data}{a SparkDataFrame.}

\item{...}{additional column argument(s) each in the form name = col.}

\item{_data}{a SparkDataFrame.}
}
\value{
A new SparkDataFrame with the new columns added or replaced.
}
\description{
Return a new SparkDataFrame with the specified columns added or replaced.
}
\note{
mutate since 1.4.0

transform since 1.5.0
}
\examples{
\dontrun{
sparkR.session()
path <- "path/to/file.json"
df <- read.json(path)
newDF <- mutate(df, newCol = df$col1 * 5, newCol2 = df$col1 * 2)
names(newDF) # Will contain newCol, newCol2
newDF2 <- transform(df, newCol = df$col1 / 5, newCol2 = df$col1 * 2)

df <- createDataFrame(list(list("Andy", 30L), list("Justin", 19L)), c("name", "age"))
# Replace the "age" column
df1 <- mutate(df, age = df$age + 1L)
}
}
\seealso{
\link{rename} \link{withColumn}

Other SparkDataFrame functions: \code{\link{SparkDataFrame-class}},
  \code{\link{agg}}, \code{\link{arrange}},
  \code{\link{as.data.frame}}, \code{\link{attach}},
  \code{\link{cache}}, \code{\link{coalesce}},
  \code{\link{collect}}, \code{\link{colnames}},
  \code{\link{coltypes}},
  \code{\link{createOrReplaceTempView}},
  \code{\link{crossJoin}}, \code{\link{dapplyCollect}},
  \code{\link{dapply}}, \code{\link{describe}},
  \code{\link{dim}}, \code{\link{distinct}},
  \code{\link{dropDuplicates}}, \code{\link{dropna}},
  \code{\link{drop}}, \code{\link{dtypes}},
  \code{\link{except}}, \code{\link{explain}},
  \code{\link{filter}}, \code{\link{first}},
  \code{\link{gapplyCollect}}, \code{\link{gapply}},
  \code{\link{getNumPartitions}}, \code{\link{group_by}},
  \code{\link{head}}, \code{\link{histogram}},
  \code{\link{insertInto}}, \code{\link{intersect}},
  \code{\link{isLocal}}, \code{\link{join}},
  \code{\link{limit}}, \code{\link{merge}},
  \code{\link{ncol}}, \code{\link{nrow}},
  \code{\link{persist}}, \code{\link{printSchema}},
  \code{\link{randomSplit}}, \code{\link{rbind}},
  \code{\link{registerTempTable}}, \code{\link{rename}},
  \code{\link{repartition}}, \code{\link{sample}},
  \code{\link{saveAsTable}}, \code{\link{schema}},
  \code{\link{selectExpr}}, \code{\link{select}},
  \code{\link{showDF}}, \code{\link{show}},
  \code{\link{storageLevel}}, \code{\link{str}},
  \code{\link{subset}}, \code{\link{take}},
  \code{\link{union}}, \code{\link{unpersist}},
  \code{\link{withColumn}}, \code{\link{with}},
  \code{\link{write.df}}, \code{\link{write.jdbc}},
  \code{\link{write.json}}, \code{\link{write.orc}},
  \code{\link{write.parquet}}, \code{\link{write.text}}
}
