% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/WindowSpec.R
\docType{methods}
\name{over}
\alias{over}
\alias{over}
\alias{over,Column,WindowSpec-method}
\title{over}
\usage{
over(x, window)

\S4method{over}{Column,WindowSpec}(x, window)
}
\arguments{
\item{x}{a Column, usually one returned by window function(s).}

\item{window}{a WindowSpec object. Can be created by \code{windowPartitionBy} or
\code{windowOrderBy} and configured by other WindowSpec methods.}
}
\description{
Define a windowing column.
}
\note{
over since 2.0.0
}
\examples{
\dontrun{
  df <- createDataFrame(mtcars)

  # Partition by am (transmission) and order by hp (horsepower)
  ws <- orderBy(windowPartitionBy("am"), "hp")

  # Rank on hp within each partition
  out <- select(df, over(rank(), ws), df$hp, df$am)

  # Lag mpg values by 1 row on the partition-and-ordered table
  out <- select(df, over(lead(df$mpg), ws), df$mpg, df$hp, df$am)
}
}
\seealso{
Other colum_func: \code{\link{alias}},
  \code{\link{between}}, \code{\link{cast}},
  \code{\link{endsWith}}, \code{\link{otherwise}},
  \code{\link{startsWith}}, \code{\link{substr}}
}
