# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393


penaltymatrix <- function(sx, sy=NULL, Y){
    
    if (is.null(sy)){
        z1 <- numeric(length(which(is.na(Y[1,])==1)))
        z2 <- numeric(length(which(is.na(Y[1,])==1)))
        m=1
        for(j in 1:length(sx)){
            if(is.na(Y[1,j])!= 1){
                z1[m] = sx[j]
                m=m+1
            }
        }

        p <- length(z1)
        h <- diff(z1,lag=1)
        Q <- matrix(0, nrow=p-2, ncol=p)
        R <- matrix(0, nrow=p-2, ncol=p-2)
        
        for( j in 1:(p-2)){
            Q[j,j] <- 1/h[j]
            Q[j,j+1] <- -1/h[j]-1/h[j+1]
            Q[j,j+2] <- 1/h[j+1]
            R[j,j] <- (h[j]+h[j+1])/3
        }
        for(j in 1:(p-3))
            R[j,j+1] <- R[j+1,j] <- h[j+1]/6
        return(t(Q)%*%solve(R)%*%Q)
    }else{
      
        z1 <- numeric(length(which(is.na(Y[1,])==1)))
        z2 <- numeric(length(which(is.na(Y[1,])==1)))
        m=1
        for(j in 1:length(sx)){
            for(i in 1:length(sy)){
                if(is.na(Y[1,i+j])!= 1){
                    z1[m] = sx[j]#/max(lon_ind)
                    z2[m] = sy[i]#/max(lat_ind)
                    m=m+1
                }
            }
        }
    
        p.dim <- length(z1)
        L <- matrix(0, nrow= p.dim+3, ncol= p.dim+3)
        P <- matrix(0, nrow= p.dim, ncol= 2)
        P[,1] <- z1
        P[,2] <- z2
        
        for(i in 1: p.dim){
            for(j in 1: p.dim){
                if(j >i){
                    r <-sqrt((P[i,1]-P[j,1])^2+(P[i,2]-P[j,2])^2)
                    L[i,j] <- r^2*log(r)
                }
            }
        }
        L[(1:p.dim),p.dim+1] <- rep(1,p.dim)
        L[(1:p.dim),p.dim+2] <- P[,1]
        L[(1:p.dim),p.dim+3] <- P[,2]
        
        L <- L+t(L)
        eig.L <- eigen(L, symmetric=TRUE)
        e <- eig.L$vectors
        lam <- diag(1/eig.L$values)
        
        Lp <- e%*%lam%*%t(e)
        Omega <- t(Lp[1:p.dim, 1:p.dim])%*%L[1:p.dim, 1:p.dim]%*%Lp[1:p.dim, 1:p.dim]

        return(Omega)
    }
}

eigenest <- function(Spatpca, covariance, gamma){
  p = nrow(Spatpca)
  M = t(Spatpca)%*%covariance%*%Spatpca
  M.eig = eigen(M,symmetric=T)
  K = ncol(Spatpca)
  m_star = K
  total.var = sum(diag(covariance))
  temp_v = total.var - sum(M.eig$values)
  err = (total.var - sum(M.eig$values-gamma))/(p-m_star)

  while(err > M.eig$values[m_star]-gamma){
    if(m_star == 1){
      err = (total.var - M.eig$values[1] + gamma)/(p-1)
      break
    }
    temp_v = temp_v + M.eig$values[m_star]
    m_star = m_star-1
    err  = (temp_v + m_star*gamma)/(p-m_star)
  }
  if(err > M.eig$values[m_star] - gamma)
    err = total.var/(p)
  eigenvalue = pmax(M.eig$values - err - gamma,0)
  
  Phi = as.matrix(Spatpca)%*%M.eig$vectors
  Sigma = Phi%*%diag(eigenvalue,K)%*%t(Phi)
  return(list(err = err, Phi = Phi, eigenvalue = eigenvalue,Sigma = Sigma))
}
g_fn <- function(x, y, d){
    if(d==2)
    r = norm(x-y,"F")
    if(d==1)
    r = abs(x-y)
    if(d>3){stop("d should be less than 4 or r should be positive")}
    if(r == 0){return(0)}
    if(d==2){return(r^2*log(r)/(16*pi))}
    else{return(gamma(d/2-2)/(16*pi^(d/2))*r^(4-d))}
}

eigenfn <- function(z, sx, sy = NULL, Phi){
    K <- ncol(Phi)
    p <- nrow(Phi)
    G <- matrix(0, p, p)
    if(is.null(sy)){
        d <- 1
        E <- matrix(0, p, 2)
        E[,1] <- rep(1,p)
        m=1
        for(j in 1:length(sx)){
            E[m,2] <- sx[j]
            m <- m+1
        }
        for(i in 1:p)
        for(j in 1:p)
        G[i,j] = g_fn(sx[i], sx[j],1)
    }else{
        d <- 2
        E <- matrix(0, p,3)
        E[,1] = rep(1, p)
        m=1
        for(j in 1:length(sx)){
            for(i in 1:length(sy)){
           #     if(is.na(Y[1, i+j])!= 1){
                E[m,2] = sx[j]
                E[m,3] = sy[i]
                m=m+1
            #    }
            }
        }
        for(i in 1:p)
        for(j in 1:p)
        G[i,j] = g_fn(E[i,2],E[j,3],2)
    }
    
    H <- matrix(0, p+d+1, p+d+1)
    H[1:p, 1:p] <- G
    H[(p+1):(p+d+1), 1:p] <- t(E)
    H[1:p, ((p+1):(p+d+1))] <- E
    H.solve <- solve(H)
    
    Phi_star <- para <- matrix(0, p+d+1, K)
    Phi_star[1:p,]<- Phi
    para <- H.solve%*%Phi_star
    
    eigen_fn <- array(0, c(nrow(z),K))
    
      for(newi in 1:nrow(z)){
        for(i in 1:K){
            sum <- 0
            for(j in 1:p){
                sum <- para[j,i]*g_fn(as.matrix(z[newi,]),E[j,-1], d) + sum
            }
            eigen_fn[newi,i] <- sum + sum(t(para[-(1:(p+1)),i])%*%as.matrix(z[newi,])) + para[p+1,i]
        }
    }
    return(eigen_fn)
}


#' Regularized PCA for spatial data
#'
#' @description Produce spatial patterns at the coordinate grids according to a smoothness parameter tau1 and a sparseness parameter tau2.
#' @param Y Data matrix (\eqn{n \times p}) stores the values at \eqn{p} grids with sample size \eqn{n}. If the dimension of grids are two, convert each sample to a vector form with length \eqn{p}.
#' @param sx Numeric vector of \eqn{x}-coordinates of grids.
#' @param sy Numeric vector of \eqn{y}-coordinates of grids. If NULL, it is a one-dimensional case.
#' @param K User-supplied number of eigenfunctions.
#' @param tau1 User-supplied nonnegative roughness parameter value.
#' @param tau2 User-supplied nonnegative sparseness parameter value.
#' @param center If TRUE, center the columns of Y. Default is FALSE.
#' @param maxit Maximum number of iterations. Default value is \eqn{10^2}.
#' @param thr Threshold for convergence. Default value is \eqn{10^{-6}}.
#' @param sx.new Numeric vector of new \eqn{x}-coordinates of grids. If NULL, it is sx.
#' @param sy.new Numeric vector of new \eqn{y}-coordinates of grids. If NULL, it is sy.
#' @author Wen-Ting Wang and Hsin-Cheng Huang
#' @return \item{eigenfn}{Estimated eigenfunctions at the grids of sx.new and sy.new.}
#' @return \item{sx}{Input vector of \eqn{x}-coordinates used in the procedure.}
#' @return \item{sy}{Input vector of \eqn{y}-coordinates used in the procedure.}
#' @return \item{tau1}{Input value of smoothness parameter.}
#' @return \item{tau2}{Input value of sparseness parameter.}
#' @return \item{K}{Input number of eigenfunctions.}
#' @seealso \code{\link{cv.spatpca}}, \code{\link{plot.spatpca}}
#' @examples
#' \dontrun{
#' s.1D <- as.matrix(seq(-5, 5, length = 50))
#' Phi.true.1D <- exp(-s.1D^2)/norm(exp(-s.1D^2),"F")
#' Y.1D <- rnorm(n = 100, sd = 3)%*%t(Phi.true.1D) + matrix(rnorm(n = 100*50), 100, 50)
#' Phi.est <- spatpca(Y = Y.1D, sx = s.1D, K = 1, tau1 = 10, tau2 = 10)
#' plot(Phi.est)}
#' @details The proposed objective function is written as
#' \deqn{\min_{\bm{\Phi}} \|\bm{Y}-\bm{Y}\bm{\Phi}\bm{\Phi}'\|^2_F +\tau_1\mbox{tr}(\bm{\Phi}^T\bm{\Omega}\bm{\Phi})+\tau_2\sum_{k=1}^K\sum_{j=1}^p |\phi_{jk}|,}
#' \eqn{\mbox{subject to $ \bm{\Phi}^T\bm{\Phi}=\bm{I}_K$,}} where \eqn{\bm{Y}} is a data matrix, \eqn{{\bm{\Omega}}} is a smoothness matrix, and \eqn{\bm{\Phi}=\{\phi_{jk}\}}.}

#' @references Wang, W.-T., Huang, H.-C. (2015). Regularized principal component analysis for spatial data. Manuscript.
#' @export
spatpca <- function(Y, sx, sy = NULL, K, tau1, tau2, center = FALSE, maxit = 1e+2, thr =1e-6, sx.new = NULL, sy.new = NULL){
    call <- match.call()
    if (length(sx) < 3)
        stop("Number of coordinates of grids must be larger than 2")
    if(length(K) !=1 & (K <= 0 || (K%%1) != 0))
        stop("rank K must be a positive integer")
    else if(K >= min(dim(Y)))
        stop("rank K must be less than the rank of data matrix")

    if (length(tau1) == 1) {
        if (!is.double(tau1) && tau1 < 0)
            stop("A tau1 value must be nonnegative")
    }else{
        stop("tau1 values must a non-negative value")
    }
 
    if (length(tau2) == 1) {
        if (!is.double(tau2) && tau2 < 0)
            stop("A tau2 value must be nonnegative")
        else if (tau2 ==0){l2 = tau2}
        else{
            l2.max <- tau2
            l2.min <- tau2/1e6
            l2 <- c(exp(seq(log(l2.min),log(l2.max),length=100)))
        }
    }else{
      stop("tau2 values must a non-negative value")
    }
      
    Omega <- penaltymatrix(sx, sy, Y)
    if(center == TRUE)
      Y <- Y-apply(Y,2,"mean")
    rho.incre <- 1.5
    n <- nrow(Y)
    p <- ncol(Y)
    
    Phi <- array(0, c(p,K))
    Phi <- spatPCA_rcpp(Y, K, Omega, tau1, l2, rho.incre, maxit, thr)
    
    if(!is.null(sy)){
        if (is.null(sx.new)||is.null(sy.new)){
            sx.new <- sx
            sy.new <- sy
        }else{
            z = cbind(sx.new,sy.new)
            Phi <- eigenfn(z = z,sx = sx, sy = sy, Phi = as.matrix(Phi))
        }
    }else{
        if (is.null(sx.new)||is.null(sy.new)){
            sx.new <- sx
            sy.new <- NULL
        }else{
            z = as.matrix(sx.new)
            Phi <- eigenfn(z = z,sx = sx, sy = sy, Phi = as.matrix(Phi))
        }
    }
    
    obj.spatPCA <- list(call=call, eigenfn = Phi, sx = sx.new, sy = sy.new, tau1 = tau1, tau2 = tau2, K = K, center = center)
    
    class(obj.spatPCA) <- "spatpca"
    return(obj.spatPCA)
}

#' M-fold cross-validation for SpatPCA.
#'
#' @description Execute M-fold cross-validation to select the tuning parameters, tau1 and tau2, and produce the corresponding estimated eigenfunctions.
#' @param Y Data matrix (\eqn{n \times p}) stores the values at \eqn{p} grids with sample size \eqn{n}. If the dimension of grids are two, convert each sample to a vector form with length \eqn{p}.
#' @param sx Numeric vector of \eqn{x}-coordinates of grids.
#' @param sy Numeric vector of \eqn{y}-coordinates of grids. If NULL, it is a one-dimensional case.
#' @param M Optional number of folds; default is 5. Smallest value allowable is M=2.
#' @param K User-supplied number of eigenfunctions.
#' @param tau1 Optional user-supplied numeric vector of a nonnegative smoothness parameter sequence. If NULL, 10 values in a range are used.
#' @param tau2 Optional user-supplied numeric vector of a nonnegative sparseness parameter sequence. If NULL, 10 values in a range are used.
#' @param center If TRUE, to center the columns of Y. Default is FALSE.
#' @param plot.eigen If TRUE, plot the estimated eigenfunctions. Default is TRUE.
#' @param plot.cv If TRUE, plot the image of cv values. Default is TRUE.
#' @param parallel If TRUE, see the example below. Default is FALSE.
#' @param ... Additional arguments passed to \code{\link{spatpca}}
#' @author Wen-Ting Wang and Hsin-Cheng Huang.
#' @return \item{eigenfn.cv}{The estimated eigenfunctions over the coordinates with respect to selected tuning parameters.}
#' @return \item{tau1.cv}{The selected tau1.}
#' @return \item{tau2.cv}{The selected tau2.}
#' @return \item{cv}{The v socres.}
#' @return \item{tau1}{The sequence of tau1-values used in the process.}
#' @return \item{tau2}{The sequence of tau2-values used in the process.}
#' @seealso \code{\link{spatpca}}
#' @examples
#' \dontrun{
#' ## 1D case
#' s.1D <- as.matrix(seq(-5, 5, length = 50))
#' Phi.true.1D <- exp(-s.1D^2)/norm(exp(-s.1D^2),"F")
#' Y.1D <- rnorm(n = 100, sd = 3)%*%t(Phi.true.1D) + matrix(rnorm(n = 100*50), 100, 50)
#' cv.1D <- cv.spatpca(Y = Y.1D, sx = s.1D, K = 3)
#'
#' ## 2D case
#' s.2D <- matrix(c(seq(-5, 5, length = 10), seq(-5, 5, length = 10)), nrow = 10, ncol = 2)
#' Phi.true.2D <- exp(-s.2D[,1]^2)%*%t(exp(-s.2D[,2]^2))
#' Phi.true.2D <- matrix(Phi.true.2D/norm(Phi.true.2D,"F"), ncol = 100, nrow = 1)
#' Y.2D <- rnorm(n = 100, sd = 3)%*%t(Phi.true.2D) + matrix(rnorm(n = 100*100), 100, 100)
#' cv.2D <- cv.spatpca(Y = Y.2D, sx = s.2D[,1], sy = s.2D[,2], K = 3)
#'
#' ## 2D case - parallel
#' library(doParallel)
#' registerDoParallel(cl)
#' cv.2D <- cv.spatpca(Y = Y.2D, sx = s.2D[,1], sy = s.2D[,2], K = 3, parallel = TRUE)
#' closeCluster(cl)}
#' #' @references Wang, W.-T., Huang, H.-C. (2015). Regularized principal component analysis for spatial data. Manuscript.
#' @export
cv.spatpca <- function(Y, sx, sy = NULL, M = 5, K, tau1 = NULL, tau2 = NULL, center = FALSE, plot.eigen = TRUE, plot.cv = TRUE, parallel = FALSE,...){
  call2 <- match.call()
  if(exists("Omega") == 0){
      if (length(sx) < 3)
        stop("Number of coordinates of grids must be larger than 2")
      if(!is.null(sy) & length(sy) < 3)
        stop("Number of coordinates of grids must be larger than 2")
      Omega <- penaltymatrix(sx, sy, Y)
  }
  if (M < 2 || M >= nrow(Y))
    stop("Number of folds must be larger than 1 and less than sample size")
  if (!is.null(tau1) & length(tau1) < 2)
    stop("Need more than one tau1 candidate value")
  if (!is.null(tau2) & length(tau2) < 2)
    stop("Need more than one tau2 candidate value")
  if(length(K) !=1 & (K <= 0 || (K%%1) != 0))
    stop("Need a positive integer rank K value")
  else if(K >= min(dim(Y)))
    stop("rank K must be less than the rank of data matrix")
  
 
  if(center == TRUE)
    Y = Y - apply(Y , 2, "mean")
  n <- nrow(Y)
  p <- ncol(Y)
  cov <- t(Y)%*%Y
  eigen.Y <- eigen(cov, symmetric=T)
  
  if(is.null(tau2)) {
    ntau2 <- 11         
    max.tau2  <- sum(abs(cov[, which.max(diag(cov))]))
    tau2 <- c(0,exp(seq(log(max.tau2/1e3), log(max.tau2), length = (ntau2-1))))     
  }else{ 
    ntau2 <- length(tau2)
  }
  
  if(is.null(tau1)) {
    ntau1 <- 31
    tt2 <- rep(0,(ntau1-1))
    for( i in 1:(ntau1-1)){
      dd2 = eigen(cov - 10^(i+1)*Omega, symmetric=T)$vector[,1]
      tt2[i] <- sum(diag(t(dd2)%*%Omega%*%dd2))
    }
    tt0 <- sum(diag(t(eigen.Y$vector[,1])%*%Omega%*%eigen.Y$vector[,1]))
    max.tau1 <- max(10^(1+which.min(abs(tt2/tt0 - 1/p))), p)
    tau1<- c(0,exp(seq(log(max.tau1/1e3), log(max.tau1), length = (ntau1-1))))
    
  }else{
    ntau1 <- length(tau1)
  }
  
  if(exists("thr") == 0) {thr <- 1e-6} else{thr <- thr}
  if(exists("maxit") == 0) {maxit <- 1e2} else{maxit <- maxit}
  if(exists("rho.incre") == 0) {rho.incre <- 1.5} else{rho.incre <- rho.incre}
  
  stra <- sample(rep(1:M, length.out = n))
  cv = array(0,c(ntau1, ntau2))

  if(parallel){
  #  requireNamespace("foreach", quietly = TRUE)
    cv <- foreach::"%dopar%"(foreach::foreach(i = 1:M,.packages=c("SpatPCA") ,.combine="+",.export=c("spatPCAcv_rcpp_parallel")),
                             {spatPCAcv_rcpp_parallel(Y, i, K, Omega, tau1, tau2, stra, rho.incre, maxit, thr)})
  }else{  
    cv<- spatPCAcv_rcpp(Y, M, K, Omega, tau1, tau2, stra, rho.incre, maxit, thr)
  }
  
  b1 <- ceiling(which.min(cv)/ntau1)
  a1 <- which.min(cv)%%ntau1
  a1 <- (a1 == 0)*ntau1 + (b1 != 0)*a1
  est <- spatpca(Y = Y, sx = sx, sy = sy,K = K, tau1 = tau1[a1], tau2 = tau2[b1])
  
  if(plot.eigen == TRUE){
    plot(est)
  }
  if(plot.cv == TRUE){
    if(plot.eigen == TRUE){
      cat("press enter\n")
      readline()
    }
    image.plot(tau1, tau2, cv/M, main = paste("CV score"), xlab = "tau1", ylab = "tau2")
  }
  
  obj.cv <- list(call=call2, eigenfn.cv = est$eigen, tau1.cv = tau1[a1], tau2.cv = tau2[b1],cv = cv/M, tau1 = tau1, tau2 = tau2, K = K, center = center)
  class(obj.cv) <- "cv.spatpca"
  return(obj.cv)
}

#' Plot eigenfunctions from an spatpca object
#'
#' @method plot spatpca
#' @description Produce plots of eigenfunctions according to a spatpca object.
#' @param x A "spatpca" object.
#' @param ... Additional arguments for generic plot.
#' @return NULL.
#' @author Wen-Ting Wang and Hsin-Cheng Huang.
#' @seealso \code{\link{spatpca}}, \code{\link{cv.spatpca}}
#' @examples
#' \dontrun{
#' s.1D <- as.matrix(seq(-5, 5, length = 50))
#' Phi.true.1D <- exp(-s.1D^2)/norm(exp(-s.1D^2),"F")
#' Y.1D <- rnorm(n = 100, sd = 3)%*%t(Phi.true.1D) + matrix(rnorm(n = 100*50), 100, 50)
#' Phi.est <- spatpca(Y = Y.1D, sx = s.1D, K = 1, tau1 = 100, tau2 = 100)
#' plot(Phi.est)}
#' @references Wang, W.-T., Huang, H.-C. (2014). Regularized principal component analysis for spatial data. Manuscript.
#' @export
plot.spatpca <- function(x,...){
  sx <- x$sx
  sy <- x$sy
  eigenfunction <- x$eigenfn
  tau1 <- x$tau1
  tau2 <- x$tau2
  K <- x$K
  
  if(is.null(sy)){
    for(k in 1:K){
      plot(sx,eigenfunction[,k],type="l", main=paste("Eigenfunction",k),...)
      mtext(paste( "tau1 = ", round(tau1,1),", tau2=", round(tau2,1)),3)
      if(k !=K){
        cat("press enter\n")
        readline()
      }
    }
  }
  else{
    for(k in 1:K){
      image.plot(sx,sy,matrix(eigenfunction[,k], length(sx), length(sy)), main=paste("Eigenfunction",k),...)
      mtext(paste( "tau1 = ", round(tau1,1),", tau2=", round(tau2,1)),3)
      if(k !=K){
        cat("press enter\n")
        readline()
      }
    }
  }
  invisible()
}



#' M-fold cross-validation for covariance estimation
#'
#' @description Execute M-fold cross-validation to select a tuning parameter, gamma, and produce the corresponding estimated covariance functions
#' @param Y Data matrix (\eqn{n \times p}) stores the values at \eqn{p} grids with sample size \eqn{n}. If the dimension of grids are two, convert each sample to a vector form with length \eqn{p}.
#' @param basis "cv.spatpca" object or "spatpca" object.
#' @param M Optional number of folds; default is 5. Smallest value allowable is M=2.
#' @param gamma Optional user-supplied numeric vector of a nonnegative tuning parameter sequence. If NULL, 10 values in a range are used.
#' @author Wen-Ting Wang and Hsin-Cheng Huang.
#' @return \item{cov}{The estimated covariance function over the coordinates with respect to the selected tuning parameter.}
#' @return \item{gamma.cv}{The selected gamma.}
#' @return \item{cv}{The cv socres.}
#' @return \item{gamma}{The sequence of gamma-values used in the process.}
#' @seealso  \code{\link{spatpca}}, \code{\link{cv.spatpca}}
#' @examples
#' \dontrun{
#' ## 1D case
#' s.1D <- as.matrix(seq(-5, 5, length = 50))
#' Phi.true.1D <- exp(-s.1D^2)/norm(exp(-s.1D^2),"F")
#' Y.1D <- rnorm(n = 100, sd = 3)%*%t(Phi.true.1D) + matrix(rnorm(n = 100*50), 100, 50)
#' cv.1D <- cv.spatpca(Y = Y.1D, sx = s.1D, K = 3)
#' cov.est <- cv.covfn(Y = Y.1D, basis = cv.1D)}
#' @references Wang, W.-T., Huang, H.-C. (2015). Regularized Principal Component Analysis for Spatial Data. Manuscript.
#' @export
cv.covfn <- function(Y, basis, M = 5, gamma = NULL){
 
    sx <- basis$sx
    sy <- basis$sy
    Phi <- basis$eigenfn
    K <- basis$K
    center <- basis$center
     
  if(center == TRUE)
    Y <- Y - apply(Y, 2, "mean")

  n <- nrow(Y)
  p <- ncol(Y)
  covariance <- t(Y)%*%(Y)/n
  
  if(is.null(gamma)) {
    gsize <- 10
    gammamax <- eigen(t(Phi)%*%covariance%*%Phi, symmetric = TRUE)$values[1]
    gamma <- c(0,exp(seq(log(gammamax/1e3), log(gammamax), length = gsize-1)))
  }
  nk2 = sample(rep(1:5, length.out = n))
  
  cvgamma <-spatPCAcv_gamma(Y = Y, Phi = Phi, M = 5, gamma = gamma, nk = nk2)
  
  for(l in 1:gsize)
    if(min(cvgamma) == min(cvgamma[l]))
      break
  gamma.cv = gamma[l]
  
  ###covariance
  temp = eigenest(Phi, covariance, gamma.cv)
  err = temp$err
  eigenvalueour = temp$eigenvalue
  PhiourK1 = temp$Phi
  cov.spatPCA = temp$Sigma
  

  return(list(cov = cov.spatPCA, gamma.cv = gamma.cv, cv = cvgamma, gamma=gamma))
}
