% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridandmat.R
\name{CreateDistMatrix}
\alias{CreateDistMatrix}
\title{Create a Distance Matrix Between Two Sp Objects}
\usage{
CreateDistMatrix(knownpts, unknownpts, longlat = FALSE, bypassctrl = FALSE)
}
\arguments{
\item{knownpts}{sp object; rows of the distance matrix.}

\item{unknownpts}{sp object; columns of the distance matrix.}

\item{longlat}{logical; euclidean distance (FALSE, default) or Great Circle distance (TRUE).}

\item{bypassctrl}{logical; bypass the distance matrix size control (see Details).}
}
\value{
A distance matrix, row names are \code{knownpts} row names, column names are \code{unknownpts} row names.
}
\description{
This function creates a distance matrix between two 
sp objects (SpatialPointsDataFrame or SpatialPolygonsDataFrame).
}
\details{
The function returns a full matrix of distances in the metric of the 
points if \code{longlat} is FALSE, or in kilometers if \code{longlat} is TRUE. This is a wrapper
for the \code{\link{spDists}} function. 

If the matrix to compute is too large (more than 100,000,000 cells or more than 10,000,000 origins or destinations) 
the function sends a confirmation message to warn users about the amount of RAM mobilized. 
Use \code{bypassctrl} = TRUE to skip this control.
}
\examples{
# Create a SpatialPointsDataFrame grid of spatMask extent and 200 meters 
# resolution
data(spatData)
mygrid <- CreateGrid(w = spatMask, resolution = 200)
# Create a distance matrix between known spatPts and mygrid
mymat <- CreateDistMatrix(knownpts = spatPts, unknownpts = mygrid, 
                          longlat = FALSE, bypassctrl = FALSE)
mymat[1:5,1:5]
nrow(spatPts)
nrow(mygrid)
dim(mymat)
}
\seealso{
\link{CreateGrid}.
}

