% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{swd}
\alias{swd}
\title{Sum Within Distance (Spatially Balanced Sampling Design)}
\usage{
swd(dis, nsamp, bexp, nrepl = 1L, niter = 10L)
}
\arguments{
\item{dis}{A distance matrix NxN that specifies how far are all the pairs
of units in the population.}

\item{nsamp}{Sample size.}

\item{bexp}{Parameter \eqn{\beta} for the algorithm. The higher
\eqn{\beta} is, the more the sample is going to be spread.}

\item{nrepl}{Number of samples to draw (default = 1).}

\item{niter}{Number of iterations for the algorithm. More iterations are
better but require more time. Usually 10 is very efficient (default = 10).}
}
\value{
Return a matrix \code{nrepl} x \code{nsamp}, which contains the
\code{nrepl} selected samples, each of them stored in a row. In particular,
the i-th row contains all labels of units selected in the i-th sample.
}
\description{
Selects spatially balanced samples through the use of the
Sum Within Distance design (SWD). To have a constant inclusion
probabilities \eqn{\pi_{i}=nsamp/N}, where \eqn{nsamp} is sample size and
\eqn{N} is population size, the distance matrix has to be standardized with
function \code{\link{stsum}}.
}
\examples{
# Example 1
# Draw 20 samples of dimension 15 without constant probabilities and beta = 1
dis <- as.matrix(dist(cbind(income_emilia$x_coord, income_emilia$y_coord))) # distance matrix
nsamp <- 15  # sample size
nrepl <- 20  # number of samples to draw
niter <- 10  # number of iterations in the algorithm
bexp <- 10   # parameter beta
samples <- swd(dis, niter, nsamp, nrepl, bexp)  # drawn samples
\donttest{
# Example 2
# Draw 20 samples of dimension 15 with constant probabilities equal to nsamp/N and beta = 10
# with N = population size
dis <- as.matrix(dist(cbind(income_emilia$x_coord,income_emilia$y_coord))) # distance matrix
nsamp <- 15  # sample size
nrepl <- 20  # numbers of samples to drawn
niter <- 10  # numbers of iterations in the algorithm
bexp <- 10   # parameter beta
vec <- rep(1, nrow(dis)) # vector of constraints
stand_dist <- stsum(dis, vec, 1e-15, 1000) # standardized matrix
samples <- swd(stand_dist, niter, nsamp, nrepl, bexp)  # drawn samples
}
}
\references{
Benedetti R, Piersimoni F (2017). “A spatially balanced design with
probability function proportional to the within sample distance.”
\emph{Biometrical Journal}, \strong{59}(5), 1067–1084.
}
