% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DressEnsemble.R
\name{DressEnsemble}
\alias{DressEnsemble}
\title{Transform an ensemble forecast to a continuous forecast distribution by kernel dressing.}
\usage{
DressEnsemble(ens, dressing.method = "silverman", parameters = NA)
}
\arguments{
\item{ens}{a N*R matrix representing N time instances of real-valued R-member ensemble forecasts}

\item{dressing.method}{One of "silverman" (default), "akd", "akd.fit". See Details.}

\item{parameters}{A list, containing the parameters for the dressing method. See Details.}
}
\value{
The function returns a list with elements `ens` (a N*R matrix, where ens[t,r] is the mean of the r-th kernel at time instance t) and `ker.wd` (a N*R matrix, where ker.wd[t,r] is the standard deviation of the r-th kernel at time t)
}
\description{
Transform an ensemble forecast to a continuous forecast distribution by kernel dressing.
}
\details{
The dressing methods currently implemented and their required parameters are:
\describe{
\item{"silverman" (default)}{No parameters are given. At time instance `n` each ensemble member is replaced by a Gaussian kernel with mean ens[n, k] and variance (4 / 3 / K)^0.4 * var(ens[n, ]). This method is called "Silverman's rule of thumb" and provides a simple non-parametric method for smoothing a discrete ensemble.}
\item{"akd"}{Affine Kernel Dressing. The required parameters are list(r1, r2, a, s1, s2). The `k`-th ensemble member at time instance `n` is dressed with a Gaussian kernel with mean r1 + r2 * mean(ens[n,]) + a * ens[n, k] and variance (4 / 3 / K)^0.4 * (s1 + s2 * a^2 * var(ens[n,])). Negative variances are set to zero. Note that parameters = list(r1=0, r2=0, a=1, s1=0, s2=1) yields the same dressed ensemble as dressing.method="silverman".}
\item{"akd.fit"}{Affine Kernel Dressing with fitted parameters. The required parameters is list(obs), where `obs` is a vector of observations which are used to optimize the parameters r1, r2, a, s1, s2 by CRPS minimization. See ?FitAkdParameters for more information.}
}
}
\examples{
data(eurotempforecast)
d.silverman <- DressEnsemble(ens)
d.akd <- DressEnsemble(ens, dressing.method="akd", 
                       parameters=list(r1=0, r2=0, a=1, 
                                       s1=0, s2=0))
d.akd.fit <- DressEnsemble(ens, dressing.method="akd.fit", 
                           parameters=list(obs=obs))
}
\references{
Silverman, B.W. (1998). Density Estimation for Statistics and Data Analysis. London: Chapman & Hall/CRC. ISBN 0-412-24620-1.
Broecker J. and Smith L. (2008). From ensemble forecasts to predictive distribution functions. Tellus (2008), 60A, 663--678. DOI 10.1111/j.1600-0870.2008.00333.x.
}
\seealso{
DressCrps, DressIgn, GetDensity, FitAkdParameters
}
