% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DressIgn.R
\name{DressIgn}
\alias{DressIgn}
\title{Calculate the Logarithmic (Ignorance) Score for a mixture of Normal distributions, for example generated by ensemble dressing}
\usage{
DressIgn(dressed.ens, obs)
}
\arguments{
\item{dressed.ens}{a list with elements `ens`, a N*R matrix representing N time instances of kernel centers, and `ker.wd`, a N*R matrix with corresponding kernel standard deviations. See function `DressEnsemble`}

\item{obs}{a numeric vector of length N with real-valued observations}
}
\value{
numeric vector of length N with the Ignorance score values
}
\description{
Calculate the Logarithmic (Ignorance) Score for a mixture of Normal distributions, for example generated by ensemble dressing
}
\examples{
data(eurotempforecast)
d.ens <- DressEnsemble(ens)
DressIgn(d.ens, obs)
}
\references{
Roulston and Smith (2002) Evaluating Probabilistic Forecasts Using Information Theory, \doi{10.1175/1520-0493(2002)130<1653:EPFUIT>2.0.CO;2}
}
\seealso{
DressEnsemble, DressCrps
}
