% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.pre_paleoTS.R
\name{plot.pre_paleoTS}
\alias{plot.pre_paleoTS}
\title{plot pre-paleoTS objects}
\usage{
\method{plot}{pre_paleoTS}(x, ...)
}
\arguments{
\item{x}{object}

\item{...}{other arguments}
}
\description{
This functions throws an error on purpose, as \code{pre_paleoTS} objects can not be plotted directly. To plot them, first use \code{reduce_to_paleoTS} and use \code{plot} on the results
}
\examples{
\dontrun{
x = stasis_sl(1:4)
# throws error
plot(x)
library("paleoTS")
# correct way to plot pre-paleoTS objects
y = reduce_to_paleoTs(x)
plot(y)
# this plots via the procedures of the paleoTS package (which must be installed and loaded)
}

}
\seealso{
\code{\link[=reduce_to_paleoTS]{reduce_to_paleoTS()}}
}
