% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ple_ranger.R
\name{ple_ranger}
\alias{ple_ranger}
\title{Patient-level Estimates: Ranger}
\usage{
ple_ranger(Y, A, X, Xtest, family = "gaussian", byTrt = ifelse(family
  == "survival", FALSE, TRUE), min.node.pct = 0.1, ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate space.}

\item{Xtest}{Test set}

\item{family}{Outcome type ("gaussian", "binomial"), default is "gaussian"}

\item{byTrt}{If TRUE, fit treatment-specific ranger models. If FALSE, fit a single ranger
model with covariate space (X, A, X*A). For "gaussian" or "binomial", default is TRUE.
For "survival", default is FALSE.}

\item{min.node.pct}{Minimum sample size in forest nodes (n*min.node.pct)}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Trained random forest (ranger) model(s).
 \itemize{
  \item mod - trained model(s)
  \item pred.fun - Prediction function for trained model(s)
}
}
\description{
Uses treatment-specific (or with explicit X*A interactions) random forest models (ranger)
to obtain patient-level estimates. Used for continuous, binary, or survival outcomes.
}
\examples{
\donttest{
library(StratifiedMedicine)
## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

# Counter-factual Random Forest (treatment-specific ranger models) #
mod1 = ple_ranger(Y, A, X, Xtest=X)

}

}
\references{
Wright, M. N. & Ziegler, A. (2017). ranger: A fast implementation of 
random forests for high dimensional data in C++ and R. J Stat Softw 77:1-17. 
\url{https://doi.org/10.18637/jss.v077.i01}.
}
\seealso{
\code{\link{PRISM}}, \code{\link{ranger}}
}
