% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dependence.R
\name{plot_dependence}
\alias{plot_dependence}
\title{Partial dependence plots: Single Variable (marginal effect) or heat map (2 to 
3 variables).}
\usage{
plot_dependence(object, X = NULL, target = NULL, vars, grid.data = NULL, ...)
}
\arguments{
\item{object}{Fitted \code{ple_train} or \code{PRISM} object}

\item{X}{input covariate space. Default=NULL.}

\item{target}{Which patient-level estimate to target for PDP based plots. Default=NULL, 
which uses the estimated treatment difference.}

\item{vars}{Variables to visualize (ex: c("var1", "var2", "var3)). If no grid.data 
provided, defaults to using seq(min(var), max(var)) for each continuous variables. 
For categorical, uses all categories.}

\item{grid.data}{Input grid of values for 2-3 covariates (if 3, last variable cannot
be continuous). This is required for type="heatmap". Default=NULL.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Plot (ggplot2) object
}
\description{
Partial dependence plots: Single Variable (marginal effect) or heat map (2 to 
3 variables).
}
\examples{
\donttest{
library(StratifiedMedicine)
## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A


# Fit through ple_train wrapper #
mod = ple_train(Y=Y, A=A, X=X, Xtest=X, ple="ranger", meta="X-learner")
plot_dependence(mod, X=X, vars="X1")
}

}
\references{
\itemize{
\item Friedman, J. Greedy function approximation: A gradient boosting machine.
 Annals of statistics (2001): 1189-1232
\item Zhao, Qingyuan, and Trevor Hastie. Causal interpretations of black-box models.
 Journal of Business & Economic Statistics, to appear. (2017).
}
}
