% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nset.R
\name{nset}
\alias{nset}
\title{Find indexes for n identical elements}
\usage{
nset(x, n, first = T, warn = T)
}
\arguments{
\item{x}{a vector, normally with repeated values}

\item{n}{the amount of repetitions that needs to be identified}

\item{first}{whether to take the first repetitions (T; is the default), or
the last ones (F)}

\item{warn}{whether to warn if NA values are generated due to the lack of
right amount of repetitions}
}
\description{
For a given vector, this function gives the indexes of identical
sets for a given number of repetitions
}
\examples{
ids <- c(rep("A", 4), rep("B", 6), rep("C", 2))

val <- paste(ids, c(1:4, 1:6, 1:2), sep = "")

nset(ids, 3, warn = FALSE)

matrix(val[nset(ids, 3, warn = FALSE)], ncol = 3)

matrix(val[nset(ids, 3, first = FALSE, warn = FALSE)], ncol = 3)

}
