% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/23-subgroupset.r
\name{subgroupset}
\alias{subgroupset}
\title{UpSetR Plot with treatment effects}
\usage{
subgroupset(
  data,
  nsets = 5,
  nintersects = 40,
  sets = NULL,
  keep.order = F,
  set.metadata = NULL,
  intersections = NULL,
  matrix.color = "gray23",
  main.bar.color = "gray23",
  mainbar.y.label = "Intersection Size",
  mainbar.y.max = NULL,
  sets.bar.color = "gray23",
  sets.x.label = "Set Size",
  point.size = 2.2,
  line.size = 0.7,
  mb.ratio = c(0.7, 0.3),
  expression = NULL,
  att.pos = NULL,
  att.color = main.bar.color,
  order.by = c("freq", "degree"),
  decreasing = c(T, F),
  show.numbers = "yes",
  number.angles = 0,
  group.by = "degree",
  cutoff = NULL,
  queries = NULL,
  query.legend = "none",
  shade.color = "gray88",
  shade.alpha = 0.25,
  matrix.dot.alpha = 0.5,
  empty.intersections = NULL,
  color.pal = 1,
  boxplot.summary = NULL,
  effects.summary = NULL,
  outcome.type = c("continuous", "binary", "survival"),
  attribute.plots = NULL,
  scale.intersections = "identity",
  scale.sets = "identity",
  text.scale = 1,
  set_size.angles = 0,
  treatment.var = NULL,
  min.n = 20,
  icon = c("dots", "pm", "pm.circle", "value"),
  fill.trt = TRUE,
  transpose = FALSE
)
}
\arguments{
\item{data}{Data set}

\item{nsets}{Number of sets to look at}

\item{nintersects}{Number of intersections to plot. If set to NA, all intersections will be plotted.}

\item{sets}{Specific sets to look at (Include as combinations. Ex: c("Name1", "Name2"))}

\item{keep.order}{Keep sets in the order entered using the sets parameter. The default is FALSE, which orders the sets by their sizes.}

\item{set.metadata}{Metadata that offers insight to an attribute of the sets. Input should be a data frame where the first column is set names, and the
remaining columns are attributes of those sets. To learn how to use this parameter it is highly suggested to view the set metadata vignette. The link
can be found on the package's GitHub page.}

\item{intersections}{Specific intersections to include in plot entered as a list of lists.
Ex: list(list("Set name1", "Set name2"), list("Set name1", "Set name3")). If data is entered into this parameter the only data shown on the UpSet plot
will be the specific intersections listed.}

\item{matrix.color}{Color of the intersection points}

\item{main.bar.color}{Color of the main bar plot}

\item{mainbar.y.label}{The y-axis label of the intersection size bar plot}

\item{mainbar.y.max}{The maximum y value of the intersection size bar plot scale. May be useful when aligning multiple UpSet plots horizontally.}

\item{sets.bar.color}{Color of set size bar plot}

\item{sets.x.label}{The x-axis label of the set size bar plot}

\item{point.size}{Size of points in matrix plot}

\item{line.size}{Width of lines in matrix plot}

\item{mb.ratio}{Ratio between matrix plot and main bar plot (Keep in terms of hundreths)}

\item{expression}{Expression to subset attributes of intersection or element query data. Enter as string (Ex: "ColName > 3")}

\item{att.pos}{Position of attribute plot. If NULL or "bottom" the plot will be at below UpSet plot. If "top" it will be above UpSert plot}

\item{att.color}{Color of attribute histogram bins or scatterplot points for unqueried data represented by main bars. Default set to color of main bars.}

\item{order.by}{How the intersections in the matrix should be ordered by. Options include frequency (entered as "freq"), degree, or both in any order.}

\item{decreasing}{How the variables in order.by should be ordered. "freq" is decreasing (greatest to least) and "degree" is increasing (least to greatest)}

\item{show.numbers}{Show numbers of intersection sizes above bars}

\item{number.angles}{The angle of the numbers atop the intersection size bars}

\item{group.by}{How the data should be grouped ("degree" or "sets")}

\item{cutoff}{The number of intersections from each set (to cut off at) when aggregating by sets}

\item{queries}{Unified querie of intersections, elements, and custom row functions. Entered as a list that contains a list of
queries. query is the type of query being conducted. params are the parameters of the query (if any). color is the color of the points on the
plot that will represent the query. If no color is selected one will be provided automatically. active takes TRUE or FALSE, and if
TRUE, it will overlay the bars present  with the results from the query. If FALSE a tick mark will indicate the intersection size.
See examples section on how to do this.}

\item{query.legend}{Position query legend on top or bottom of UpSet plot}

\item{shade.color}{Color of row shading in matrix}

\item{shade.alpha}{Transparency of shading in matrix}

\item{matrix.dot.alpha}{Transparency of the empty intersections points in the matrix}

\item{empty.intersections}{Additionally display empty sets up to nintersects}

\item{color.pal}{Color palette for attribute plots}

\item{boxplot.summary}{Boxplots representing the distribution of a selected attribute for each intersection. Select attributes by entering a character vector of attribute names (e.g. c("Name1", "Name2")).
The maximum number of attributes that can be entered is 2.}

\item{effects.summary}{Forest plot. Select the response variable by entering a character attribute name (e.g. "y" or c("survtime", "cens")}

\item{outcome.type}{One of "continuous", "binary", or "survival" to determine the model to implement}

\item{attribute.plots}{Create custom ggplot using intersection data represented in the main bar plot. Prior to adding custom plots, the UpSet plot is set up in a 100 by 100 grid.
The attribute.plots parameter takes a list that contains the number of rows that should be allocated for the custom plot, and a list of plots with specified positions.
nrows is the number of rows the custom plots should take up. There is already 100 allocated for the custom plot. plots takes a list that contains a function that returns
a custom ggplots and the x and y aesthetics for the function. ncols is the number of columns that your ggplots should take up. See examples for how to add custom ggplots.}

\item{scale.intersections}{The scale to be used for the intersection sizes. Options: "identity", "log10", "log2"}

\item{scale.sets}{The scale to be used for the set sizes. Options: "identity", "log10", "log2"}

\item{text.scale}{Numeric, value to scale the text sizes, applies to all axis labels, tick labels, and numbers above bar plot. Can be a universal scale, or a vector containing individual scales
in the following format: c(intersection size title, intersection size tick labels, set size title, set size tick labels, set names, numbers above bars)}

\item{set_size.angles}{Numeric, angle to rotate the set size plot x-axis text}

\item{treatment.var}{A character indicating the name of the treatment variable in the dataset}

\item{min.n}{The minimum number of subjects in a subgroup to be included in the plot}

\item{icon}{One of "dots", "pm", "pm.circle", or "value" which determines the icon to use in the matrix plot}

\item{fill.trt}{A logical indicating whether the bar plot is coloured by treatment.}

\item{transpose}{A logical indicating whether to draw the plot vertically.}
}
\description{
Visualization of set intersections using novel UpSet matrix design, modified to show treatment effects and confidence intervals
}
\details{
Visualization of set data in the layout described by Lex and Gehlenborg in \url{http://www.nature.com/nmeth/journal/v11/n8/abs/nmeth.3033.html}.
The plot is modified here to select a treatment variable, compute the treatment effects and display them along with their confidence
intervals in a forest plot-like panel.
}
\note{
Data set must be formatted as described on the orginal UpSet github page: \url{http://github.com/VCG/upset/wiki}.
}
\examples{
\donttest{
data(prca)
dat <- prca
vars = data.frame(variable = names(dat), index = 1:length(names(dat)))

## 12. SubgroUpSet -----------------------------------------------------------
prca.upset = data.frame(trt = factor(ifelse(prca$rx == 1, "Experimental", "Control")),
                        bm = 1*(prca$bm == 1),
                        pf = 1*(prca$pf == 1),
                        hx = 1*(prca$hx == 1),
                        stage = 1*(prca$stage == 4),
                        age = 1*(prca$age > 75),
                        wt = 1*(prca$weight > 100),
                        survtime = prca$survtime,
                        cens = prca$cens==1)
subgroupset(prca.upset,
            order.by = "freq",
            empty.intersections = "on",
            sets = c("bm", 'pf', "hx"),
            text.scale = 1.,
            mb.ratio = c(0.25, 0.50,0.20),
            treatment.var = "trt",
            outcome.type = "survival",
            effects.summary = c("survtime", "cens"),
            query.legend = "top", icon = "pm")

subgroupset(prca.upset,
            order.by = "freq",
            empty.intersections = "on",
            sets = c("bm", 'pf', "hx"),
            text.scale = 1.,
            mb.ratio = c(0.25, 0.50,0.20),
            treatment.var = "trt",
            outcome.type = "survival",
            effects.summary = c("survtime", "cens"),
            query.legend = "top", icon = "pm", transpose = TRUE)
}

}
\references{
Lex et al. (2014). UpSet: Visualization of Intersecting Sets
IEEE Transactions on Visualization and Computer Graphics (Proceedings of InfoVis 2014), vol 20, pp. 1983-1992, (2014). \url{http://data.caleydo.org/papers/2014_infovis_upset.pdf}

Lex and Gehlenborg (2014). Points of view: Sets and intersections. Nature Methods 11, 779 (2014). \url{http://www.nature.com/nmeth/journal/v11/n8/abs/nmeth.3033.html}
}
\seealso{
Original UpSet Website: \url{http://vcg.github.io/upset/about/}

UpSetR github for additional examples: \url{http://github.com/hms-dbmi/UpSetR}
}
