% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07-ggradial-plot-function.r
\name{ggplot_radial2}
\alias{ggplot_radial2}
\title{Modified Radial (Galbraith) plot for subgroup effect size}
\usage{
ggplot_radial2(
  dat,
  covari.sel,
  trt.sel,
  resp.sel,
  outcome.type,
  range.v = NULL,
  font.size = 4,
  title = NULL,
  lab.xy = "default",
  ticks.length = 0.05
)
}
\arguments{
\item{dat}{a data set}

\item{covari.sel}{a vector of indices of the two covariates}

\item{trt.sel}{a covariate index specifying the treatment code}

\item{resp.sel}{a covariate index specifying the response variable}

\item{outcome.type}{a string specifying the type of the response variable, it can be "continuous", or "binary" or  "survival".}

\item{range.v}{a vector specifying the vertical range of graphical display.}

\item{font.size}{a number specifying the font size for the subgroup labels near points}

\item{title}{a string specifying the main title.}

\item{lab.xy}{a list of two strings specifying the labels of the x and y axes.}

\item{ticks.length}{a number from 0 to 1 to specify the length of the red
ticks indicating the treatment effect in the radial axis. A value of 1 will draw a complete line from the (0,0) point to the axis.}
}
\description{
This function produces a modified Galbraith's radial plot using ggplot. It shows the
treatment effect size of subgroups defined by the categories
of covariates. The x-axis represents the reciprocal of the standard error
of the difference between the subgroup treatment effect estimates and the
overall treatment effect estimate.
The y-axis is the
standardized effect size difference (the difference between subgroup effect
the full population effect is divided by its standard error).
Points here are for subgroups.
The grey region indicates whether subgroup effects
are homogeneous to the full population effect or not. The two arcs on the
right side show subgroup treatment effects in the original
scale, where the red spots are the projection of points from the origin on
the left side. Note that the vertical range of display can
be changed by setting different values on the associated input argument.
In addition, the function uses log odd ratio and log hazard
ratio for displaying subgroup effect sizes in binary and survival data,
respectively.
A ggplot object is returned, where further modifications can be added using the theme() function.
}
\examples{
library(dplyr)

# Load the data to be used
data(prca)
dat <- prca
dat \%>\%
  mutate(bm = factor(ifelse(bm == 0 , "No", "Yes")),
         hx = factor(ifelse(hx == 0 , "No", "Yes")))-> dat

ggplot_radial2(dat,
            covari.sel = c(4, 5, 6, 7),
            trt.sel = 3,
            resp.sel = c(1, 2),
            outcome.type = "survival",
            range.v = c(-7, 6),
            font.size = 4)
}
