% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TensProd.R
\name{TensProd}
\alias{TensProd}
\title{Compute tensor product over multiple dimensions using Khatri-Rao product}
\usage{
TensProd(L, range = NA)
}
\arguments{
\item{L}{List of length K, with matrix entries L{k}: m_k X R;}

\item{range}{Column indices over which to apply tensor product.Default is all columns (range = [1:R])}
}
\value{
Ans Array of size m_1 X m_2 ... X m_K, where the [i1,...iK]; entry is the sum of product L{k}(i1,r)*...*L{K}(iK,r) over all r in range.
}
\description{
Compute tensor product over multiple dimensions using Khatri-Rao product
}
\examples{
L <- list(matrix(rnorm(10*10),10,10),matrix(rnorm(10*10),10,10),matrix(rnorm(1000*10),1000,10))
TensProd(L)

}
