#' basic kernels
#'
#' Kernels for computing directional differences for specific directions and lag distances.
#' These have been constructed using bilinear interpolation for directions out of main axes.
#' The kernels are intended to be used with "Terra" focal functions (i.e., convolution).
#'
#' @docType data
#'
#'
#'
#' @format just matrices.
#'
#' @keywords datasets
#'
#' @references
#' 1) Trevisani, S. & Rocca, M. 2015. MAD: Robust image texture analysis for applications in high resolution geomorphometry.
#' Computers and Geosciences, vol. 81, pp. 78-92.
#'
#' 2) Trevisani, S. Teza, G., Guth, P., 2023. A simplified geostatistical approach for characterizing key aspects of short-range roughness.
#' CATENA,Volume 223, ISSN 0341-8162,https://doi.org/10.1016/j.catena.2023.106927
#'
#'
#' @source Sebastiano Trevisani
#'
#' @examples
#' #to see kernels (each one is a list with 4 kernels) of order 1
#' #These should be used with a detrended "surface"
#' #lag 1 pixel
#' k1c
#' #lag 2 pixels
#' k2c
#' #lag 4 pixels
#' k4c
#' #lag 6 pixels
#' k6c
#' #lag 8 pixels
#' k8c
#' #kernels of order 2 (differences of differences)
#' #these can be applied directly without detrending
#' #lag 05 pixel
#' k05ck2
#' #lag 1 pixel
#' k1ck2
#' #lag 2 pixels
#' k2ck2
"k1c"

#' basic kernels
#'
#' Kernels for computing directional differences for specific directions and lag distances.
#' These have been constructed using bilinear interpolation for directions out of main axes.
#' The kernels are intended to be used with "Terra" focal functions (i.e., convolution).
#'
#' @docType data
#'
#'
#'
#' @format just matrices.
#'
#' @keywords datasets
#'
#' @references
#'1) Trevisani, S. & Rocca, M. 2015. MAD: Robust image texture analysis for applications in high resolution geomorphometry.
#' Computers and Geosciences, vol. 81, pp. 78-92.
#'
#' 2) Trevisani, S. Teza, G., Guth, P., 2023. A simplified geostatistical approach for characterizing key aspects of short-range roughness.
#' CATENA,Volume 223, ISSN 0341-8162,https://doi.org/10.1016/j.catena.2023.106927
#'
#' @source Sebastiano Trevisani
#'
#' @examples
#' #to see kernels (each one is a list with 4 kernels) of order 1
#' #These should be used with a detrended "surface"
#' #lag 1 pixel
#' k1c
#' #lag 2 pixels
#' k2c
#' #lag 4 pixels
#' k4c
#' #lag 6 pixels
#' k6c
#' #lag 8 pixels
#' k8c
#' #kernels of order 2 (differences of differences)
#' #these can be applied directly without detrending
#' #lag 05 pixel
#' k05ck2
#' #lag 1 pixel
#' k1ck2
#' #lag 2 pixels
#' k2ck2
"k2c"

#' basic kernels
#'
#' Kernels for computing directional differences for specific directions and lag distances.
#' These have been constructed using bilinear interpolation for directions out of main axes.
#' The kernels are intended to be used with "Terra" focal functions (i.e., convolution).
#'
#' @docType data
#'
#'
#'
#' @format just matrices.
#'
#' @keywords datasets
#'
#' @references
#' 1) Trevisani, S. & Rocca, M. 2015. MAD: Robust image texture analysis for applications in high resolution geomorphometry.
#' Computers and Geosciences, vol. 81, pp. 78-92.
#'
#' 2) Trevisani, S. Teza, G., Guth, P., 2023. A simplified geostatistical approach for characterizing key aspects of short-range roughness.
#' CATENA,Volume 223, ISSN 0341-8162,https://doi.org/10.1016/j.catena.2023.106927
#'
#' @source Sebastiano Trevisani
#'
#' @examples
#' #to see kernels (each one is a list with 4 kernels) of order 1
#' #These should be used with a detrended "surface"
#' #lag 1 pixel
#' k1c
#' #lag 2 pixels
#' k2c
#' #lag 4 pixels
#' k4c
#' #lag 6 pixels
#' k6c
#' #lag 8 pixels
#' k8c
#' #kernels of order 2 (differences of differences)
#' #these can be applied directly without detrending
#' #lag 05 pixel
#' k05ck2
#' #lag 1 pixel
#' k1ck2
#' #lag 2 pixels
#' k2ck2
"k4c"


#' basic kernels
#'
#' Kernels for computing directional differences for specific directions and lag distances.
#' These have been constructed using bilinear interpolation for directions out of main axes.
#' The kernels are intended to be used with "Terra" focal functions (i.e., convolution).
#'
#' @docType data
#'
#'
#'
#' @format just matrices.
#'
#' @keywords datasets
#'
#' @references
#' 1) Trevisani, S. & Rocca, M. 2015. MAD: Robust image texture analysis for applications in high resolution geomorphometry.
#' Computers and Geosciences, vol. 81, pp. 78-92.
#'
#' 2) Trevisani, S. Teza, G., Guth, P., 2023. A simplified geostatistical approach for characterizing key aspects of short-range roughness.
#' CATENA,Volume 223, ISSN 0341-8162,https://doi.org/10.1016/j.catena.2023.106927
#'
#' @source Sebastiano Trevisani
#'
#' @examples
#' #to see kernels (each one is a list with 4 kernels) of order 1
#' #These should be used with a detrended "surface"
#' #lag 1 pixel
#' k1c
#' #lag 2 pixels
#' k2c
#' #lag 4 pixels
#' k4c
#' #lag 6 pixels
#' k6c
#' #lag 8 pixels
#' k8c
#' #kernels of order 2 (differences of differences)
#' #these can be applied directly without detrending
#' #lag 05 pixel
#' k05ck2
#' #lag 1 pixel
#' k1ck2
#' #lag 2 pixels
#' k2ck2
"k6c"

#' basic kernels
#'
#' Kernels for computing directional differences for specific directions and lag distances.
#' These have been constructed using bilinear interpolation for directions out of main axes.
#' The kernels are intended to be used with "Terra" focal functions (i.e., convolution).
#'
#' @docType data
#'
#'
#'
#' @format just matrices.
#'
#' @keywords datasets
#'
#' @references
#' 1) Trevisani, S. & Rocca, M. 2015. MAD: Robust image texture analysis for applications in high resolution geomorphometry.
#' Computers and Geosciences, vol. 81, pp. 78-92.
#'
#' 2) Trevisani, S. Teza, G., Guth, P., 2023. A simplified geostatistical approach for characterizing key aspects of short-range roughness.
#' CATENA,Volume 223, ISSN 0341-8162,https://doi.org/10.1016/j.catena.2023.106927
#'
#'
#' @source Sebastiano Trevisani
#'
#' @examples
#' #to see kernels (each one is a list with 4 kernels) of order 1
#' #These should be used with a detrended "surface"
#' #lag 1 pixel
#' k1c
#' #lag 2 pixels
#' k2c
#' #lag 4 pixels
#' k4c
#' #lag 6 pixels
#' k6c
#' #lag 8 pixels
#' k8c
#' #kernels of order 2 (differences of differences)
#' #these can be applied directly without detrending
#' #lag 05 pixel
#' k05ck2
#' #lag 1 pixel
#' k1ck2
#' #lag 2 pixels
#' k2ck2
"k8c"

#' basic kernels
#'
#' Kernels for computing directional differences for specific directions and lag distances.
#' These have been constructed using bilinear interpolation for directions out of main axes.
#' The kernels are intended to be used with "Terra" focal functions (i.e., convolution).
#'
#' @docType data
#'
#'
#'
#' @format just matrices.
#'
#' @keywords datasets
#'
#' @references
#' 1) Trevisani, S. & Rocca, M. 2015. MAD: Robust image texture analysis for applications in high resolution geomorphometry.
#' Computers and Geosciences, vol. 81, pp. 78-92.
#'
#' 2) Trevisani, S. Teza, G., Guth, P., 2023. A simplified geostatistical approach for characterizing key aspects of short-range roughness.
#' CATENA,Volume 223, ISSN 0341-8162,https://doi.org/10.1016/j.catena.2023.106927
#'
#'
#' @source Sebastiano Trevisani
#'
#' @examples
#' #to see kernels (each one is a list with 4 kernels) of order 1
#' #These should be used with a detrended "surface"
#' #lag 1 pixel
#' k1c
#' #lag 2 pixels
#' k2c
#' #lag 4 pixels
#' k4c
#' #lag 6 pixels
#' k6c
#' #lag 8 pixels
#' k8c
#' #kernels of order 2 (differences of differences)
#' #these can be applied directly without detrending
#' #lag 05 pixel
#' k05ck2
#' #lag 1 pixel
#' k1ck2
#' #lag 2 pixels
#' k2ck2
"k05ck2"

#' basic kernels
#'
#' Kernels for computing directional differences for specific directions and lag distances.
#' These have been constructed using bilinear interpolation for directions out of main axes.
#' The kernels are intended to be used with "Terra" focal functions (i.e., convolution).
#'
#' @docType data
#'
#'
#'
#' @format just matrices.
#'
#' @keywords datasets
#'
#' @references
#' 1) Trevisani, S. & Rocca, M. 2015. MAD: Robust image texture analysis for applications in high resolution geomorphometry.
#' Computers and Geosciences, vol. 81, pp. 78-92.
#'
#' 2) Trevisani, S. Teza, G., Guth, P., 2023. A simplified geostatistical approach for characterizing key aspects of short-range roughness.
#' CATENA,Volume 223, ISSN 0341-8162,https://doi.org/10.1016/j.catena.2023.106927
#'
#'
#' @source Sebastiano Trevisani
#'
#' @examples
#' #to see kernels (each one is a list with 4 kernels) of order 1
#' #These should be used with a detrended "surface"
#' #lag 1 pixel
#' k1c
#' #lag 2 pixels
#' k2c
#' #lag 4 pixels
#' k4c
#' #lag 6 pixels
#' k6c
#' #lag 8 pixels
#' k8c
#' #kernels of order 2 (differences of differences)
#' #these can be applied directly without detrending
#' #lag 05 pixel
#' k05ck2
#' #lag 1 pixel
#' k1ck2
#' #lag 2 pixels
#' k2ck2
"k1ck2"

#' basic kernels
#'
#' Kernels for computing directional differences for specific directions and lag distances.
#' These have been constructed using bilinear interpolation for directions out of main axes.
#' The kernels are intended to be used with "Terra" focal functions (i.e., convolution).
#'
#' @docType data
#'
#'
#'
#' @format just matrices.
#'
#' @keywords datasets
#'
#' @references
#' 1) Trevisani, S. & Rocca, M. 2015. MAD: Robust image texture analysis for applications in high resolution geomorphometry.
#' Computers and Geosciences, vol. 81, pp. 78-92.
#'
#' 2) Trevisani, S. Teza, G., Guth, P., 2023. A simplified geostatistical approach for characterizing key aspects of short-range roughness.
#' CATENA,Volume 223, ISSN 0341-8162,https://doi.org/10.1016/j.catena.2023.106927
#'
#'
#' @source Sebastiano Trevisani
#'
#' @examples
#' #to see kernels (each one is a list with 4 kernels) of order 1
#' #These should be used with a detrended "surface"
#' #lag 1 pixel
#' k1c
#' #lag 2 pixels
#' k2c
#' #lag 4 pixels
#' k4c
#' #lag 6 pixels
#' k6c
#' #lag 8 pixels
#' k8c
#' #kernels of order 2 (differences of differences)
#' #these can be applied directly without detrending
#' #lag 05 pixel
#' k05ck2
#' #lag 1 pixel
#' k1ck2
#' #lag 2 pixels
#' k2ck2
"k2ck2"
