% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFSreconstruction.R
\name{AFSreconstruction}
\alias{AFSreconstruction}
\title{Advancing front surface reconstruction}
\usage{
AFSreconstruction(points)
}
\arguments{
\item{points}{numeric matrix which stores the points, one point per row}
}
\value{
A triangle mesh, of class \code{mesh3d} (ready for plotting
  with \strong{rgl}).
}
\description{
Reconstruction of a surface from a cloud of 3D points.
}
\details{
See \href{https://doc.cgal.org/latest/Advancing_front_surface_reconstruction/index.html#Chapter_Advancing_Front_Surface_Reconstruction}{Advancing Front Surface Reconstruction}.
}
\examples{
library(SurfaceReconstruction)
data(bunny, package = "onion")
mesh <- AFSreconstruction(bunny)
library(rgl)
shade3d(mesh, color = "firebrick")
}
