% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samms_swim_parse.R
\name{swim_parse_samms}
\alias{swim_parse_samms}
\title{Formats swimming and diving data read with \code{read_results} into a
dataframe}
\usage{
swim_parse_samms(
  file_samms,
  avoid_samms = avoid,
  typo_samms = typo,
  replacement_samms = replacement,
  format_samms = format_results
)
}
\arguments{
\item{file_samms}{output from \code{read_results} of S.A.M.M.S. style results}

\item{avoid_samms}{a list of strings.  Rows in \code{file} containing these
strings will not be included. For example "Pool:", often used to label pool
records, could be passed to \code{avoid}.  The default is
\code{avoid_default}, which contains many strings similar to "Pool:", such
as "STATE:" and "Qual:".  Users can supply their own lists to \code{avoid}.}

\item{typo_samms}{a list of strings that are typos in the original results.
\code{swim_parse} is particularly sensitive to accidental double spaces, so
"Central  High School", with two spaces between "Central" and "High" is a
problem, which can be fixed.  Pass "Central  High School" to \code{typo}.
Unexpected commas as also an issue, for example "Texas, University of"
should be fixed using \code{typo} and \code{replacement}}

\item{replacement_samms}{a list of fixes for the strings in \code{typo}.
Here one could pass "Central High School" (one space between "Central" and
"High") and "Texas" to \code{replacement} fix the issues described in
\code{typo}}

\item{format_samms}{should the data be formatted for analysis (special
strings like \code{"DQ"} replaced with \code{NA}, \code{Finals_Time} as
definitive column)?  Default is \code{TRUE}}
}
\value{
returns a data frame with columns \code{Name}, \code{Place},
  \code{Age}, \code{Team}, \code{Prelims_Time}, \code{Finals_Time},
  \code{Event} & \code{DQ}.  Note all swims will have a \code{Finals_Time},
  even if that time was actually swam in the prelims (i.e. a swimmer did not
  qualify for finals).  This is so that final results for an event can be
  generated from just one column.
}
\description{
Takes the output of \code{read_results} of S.A.M.M.S. results and cleans it,
yielding a dataframe of swimming (and diving) results
}
\seealso{
\code{swim_parse} must be run on the output of
  \code{\link{read_results}}
}
