% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-Pwr.R
\name{Pwr}
\alias{Pwr}
\title{Calculates power based on a model fit}
\usage{
Pwr(object, ...)
}
\arguments{
\item{object}{an object containing the results returned by a model fitting function (e.g., \code{lme}).}

\item{\dots}{some methods for this generic function may require additional arguments.}
}
\value{
numeric scalar value.
}
\description{
This function is generic; method functions can be written to handle specific classes of objects.
}
\examples{
data("grwth_data")
lmm <- lmmModel(data = grwth_data,
                sample_id = "subject",
                time = "Time",
                treatment = "Treatment",
                tumor_vol = "TumorVolume",
                trt_control = "Control",
                drug_a = "DrugA",
                drug_b = "DrugB",
                combination = "Combination")
Pwr(lmm,
    L = c("Time:TreatmentControl" = 1,
    "Time:TreatmentDrugA" = -1,
    "Time:TreatmentDrugB" = -1,
    "Time:TreatmentCombination" = 1))
 
}
\seealso{
\code{\link{Pwr.lme}}
}
\author{
Andrzej Galecki and Tomasz Burzykowski
}
