%% File Name: TAM-package.Rd
%% File Version: 2.58

\name{TAM-package}
\alias{TAM-package}
\alias{TAM}
\docType{package}
\title{
Test Analysis Modules
}
\description{
    Includes marginal maximum likelihood estimation and joint maximum
    likelihood estimation for unidimensional and multidimensional 
    item response models. The package functionality covers the 
    Rasch model, 2PL model, 3PL model, generalized partial credit model, 
    multi-faceted Rasch model, nominal item response model, 
    structured latent class model, mixture distribution IRT models, 
    and located latent class models. Latent regression models and 
    plausible value imputation are also supported. For details see
    Adams, Wilson, and Wang, 1997, <doi:10.1177/0146621697211001>,
    Adams, Wilson, and Wu, 1997, <doi:10.3102/10769986022001047>,
    Formann, 1982, <doi:10.1002/bimj.4710240209>,
    Formann, 1992, <doi:10.1080/01621459.1992.10475229>.
}
\details{
See \url{http://www.edmeasurementsurveys.com/TAM/Tutorials/} for 
tutorials of the \pkg{TAM} package.
}
\author{
Alexander Robitzsch [aut, cre], Thomas Kiefer [aut], Margaret Wu [aut]

Maintainer: Alexander Robitzsch <robitzsch@ipn.uni-kiel.de>
}
\references{
Adams, R. J., Wilson, M., & Wang, W. C. (1997). The multidimensional random coefficients 
multinomial logit model. \emph{Applied Psychological Measurement}, \bold{21}(1), 1-23.

Adams, R. J., Wilson, M., & Wu, M. (1997).
Multilevel item response models: An approach to errors in
variables regression. \emph{Journal of Educational and Behavioral 
Statistics}, \bold{22}, 47-76.

Adams, R. J., & Wu, M. L. (2007). The mixed-coefficients multinomial logit model.
A generalized form of the Rasch model. In M. von Davier & C. H. Carstensen (Eds.):
\emph{Multivariate and mixture distribution Rasch models: Extensions and applications}
(pp. 55-76). New York: Springer.

Formann, A. K. (1982). Linear logistic latent class analysis. 
\emph{Biometrical Journal}, \bold{24}(2), 171-190.

Formann, A. K. (1992). Linear logistic latent class analysis for polytomous data. 
\emph{Journal of the American Statistical Association}, \bold{87}, 476-486.
}
\keyword{package}


%\seealso{
%%~~ Optional links to other man pages, e.g. ~~
%%~~ \code{\link[<pkg>:<pkg>-package]{<pkg>}} ~~
%}
%\examples{
%% ## ~~ simple examples of the most important functions ~~
%}
